/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.util.Locale;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodParser;
import org.joda.time.format.PeriodPrinter;

public class PeriodFormatter {
    private final PeriodPrinter iPrinter;
    private final PeriodParser iParser;
    private final Locale iLocale;
    private final PeriodType iParseType;

    public PeriodFormatter(PeriodPrinter periodPrinter, PeriodParser periodParser) {
        this.iPrinter = periodPrinter;
        this.iParser = periodParser;
        this.iLocale = null;
        this.iParseType = null;
    }

    public PeriodPrinter getPrinter() {
        return this.iPrinter;
    }

    public PeriodParser getParser() {
        return this.iParser;
    }

    public String print(ReadablePeriod readablePeriod) {
        this.checkPrinter();
        this.checkPeriod(readablePeriod);
        PeriodPrinter periodPrinter = this.getPrinter();
        StringBuffer stringBuffer = new StringBuffer(periodPrinter.calculatePrintedLength(readablePeriod, this.iLocale));
        periodPrinter.printTo(stringBuffer, readablePeriod, this.iLocale);
        return stringBuffer.toString();
    }

    private void checkPrinter() {
        if (this.iPrinter == null) {
            throw new UnsupportedOperationException("Printing not supported");
        }
    }

    private void checkPeriod(ReadablePeriod readablePeriod) {
        if (readablePeriod == null) {
            throw new IllegalArgumentException("Period must not be null");
        }
    }
}

