/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.FormatUtils;

public class DateTimeFormatter {
    private final DateTimePrinter iPrinter;
    private final DateTimeParser iParser;
    private final Locale iLocale;
    private final boolean iOffsetParsed;
    private final Chronology iChrono;
    private final DateTimeZone iZone;
    private final Integer iPivotYear;
    private final int iDefaultYear;

    public DateTimeFormatter(DateTimePrinter dateTimePrinter, DateTimeParser dateTimeParser) {
        this.iPrinter = dateTimePrinter;
        this.iParser = dateTimeParser;
        this.iLocale = null;
        this.iOffsetParsed = false;
        this.iChrono = null;
        this.iZone = null;
        this.iPivotYear = null;
        this.iDefaultYear = 2000;
    }

    private DateTimeFormatter(DateTimePrinter dateTimePrinter, DateTimeParser dateTimeParser, Locale locale, boolean bl, Chronology chronology, DateTimeZone dateTimeZone, Integer n, int n2) {
        this.iPrinter = dateTimePrinter;
        this.iParser = dateTimeParser;
        this.iLocale = locale;
        this.iOffsetParsed = bl;
        this.iChrono = chronology;
        this.iZone = dateTimeZone;
        this.iPivotYear = n;
        this.iDefaultYear = n2;
    }

    public DateTimePrinter getPrinter() {
        return this.iPrinter;
    }

    public DateTimeParser getParser() {
        return this.iParser;
    }

    public DateTimeFormatter withChronology(Chronology chronology) {
        if (this.iChrono == chronology) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, this.iOffsetParsed, chronology, this.iZone, this.iPivotYear, this.iDefaultYear);
    }

    public DateTimeFormatter withZoneUTC() {
        return this.withZone(DateTimeZone.UTC);
    }

    public DateTimeFormatter withZone(DateTimeZone dateTimeZone) {
        if (this.iZone == dateTimeZone) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, false, this.iChrono, dateTimeZone, this.iPivotYear, this.iDefaultYear);
    }

    public void printTo(StringBuffer stringBuffer, ReadableInstant readableInstant) {
        long l = DateTimeUtils.getInstantMillis(readableInstant);
        Chronology chronology = DateTimeUtils.getInstantChronology(readableInstant);
        this.printTo(stringBuffer, l, chronology);
    }

    public String print(ReadableInstant readableInstant) {
        StringBuffer stringBuffer = new StringBuffer(this.requirePrinter().estimatePrintedLength());
        this.printTo(stringBuffer, readableInstant);
        return stringBuffer.toString();
    }

    private void printTo(StringBuffer stringBuffer, long l, Chronology chronology) {
        DateTimePrinter dateTimePrinter = this.requirePrinter();
        DateTimeZone dateTimeZone = (chronology = this.selectChronology(chronology)).getZone();
        int n = dateTimeZone.getOffset(l);
        long l2 = l + (long)n;
        if ((l ^ l2) < 0L && (l ^ (long)n) >= 0L) {
            dateTimeZone = DateTimeZone.UTC;
            n = 0;
            l2 = l;
        }
        dateTimePrinter.printTo(stringBuffer, l2, chronology.withUTC(), n, dateTimeZone, this.iLocale);
    }

    private DateTimePrinter requirePrinter() {
        DateTimePrinter dateTimePrinter = this.iPrinter;
        if (dateTimePrinter == null) {
            throw new UnsupportedOperationException("Printing not supported");
        }
        return dateTimePrinter;
    }

    public long parseMillis(String string) {
        Chronology chronology;
        DateTimeParserBucket dateTimeParserBucket;
        DateTimeParser dateTimeParser = this.requireParser();
        int n = dateTimeParser.parseInto(dateTimeParserBucket = new DateTimeParserBucket(0L, chronology = this.selectChronology(this.iChrono), this.iLocale, this.iPivotYear, this.iDefaultYear), string, 0);
        if (n >= 0) {
            if (n >= string.length()) {
                return dateTimeParserBucket.computeMillis(true, string);
            }
        } else {
            n ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(string, n));
    }

    private DateTimeParser requireParser() {
        DateTimeParser dateTimeParser = this.iParser;
        if (dateTimeParser == null) {
            throw new UnsupportedOperationException("Parsing not supported");
        }
        return dateTimeParser;
    }

    private Chronology selectChronology(Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        if (this.iChrono != null) {
            chronology = this.iChrono;
        }
        if (this.iZone != null) {
            chronology = chronology.withZone(this.iZone);
        }
        return chronology;
    }
}

