/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;

public final class UnsupportedDateTimeField
extends DateTimeField
implements Serializable {
    private static HashMap<DateTimeFieldType, UnsupportedDateTimeField> cCache;
    private final DateTimeFieldType iType;
    private final DurationField iDurationField;

    public static synchronized UnsupportedDateTimeField getInstance(DateTimeFieldType dateTimeFieldType, DurationField durationField) {
        UnsupportedDateTimeField unsupportedDateTimeField;
        if (cCache == null) {
            cCache = new HashMap(7);
            unsupportedDateTimeField = null;
        } else {
            unsupportedDateTimeField = cCache.get(dateTimeFieldType);
            if (unsupportedDateTimeField != null && unsupportedDateTimeField.getDurationField() != durationField) {
                unsupportedDateTimeField = null;
            }
        }
        if (unsupportedDateTimeField == null) {
            unsupportedDateTimeField = new UnsupportedDateTimeField(dateTimeFieldType, durationField);
            cCache.put(dateTimeFieldType, unsupportedDateTimeField);
        }
        return unsupportedDateTimeField;
    }

    private UnsupportedDateTimeField(DateTimeFieldType dateTimeFieldType, DurationField durationField) {
        if (dateTimeFieldType == null || durationField == null) {
            throw new IllegalArgumentException();
        }
        this.iType = dateTimeFieldType;
        this.iDurationField = durationField;
    }

    public DateTimeFieldType getType() {
        return this.iType;
    }

    public String getName() {
        return this.iType.getName();
    }

    public boolean isSupported() {
        return false;
    }

    public int get(long l) {
        throw this.unsupported();
    }

    public String getAsText(long l, Locale locale) {
        throw this.unsupported();
    }

    public String getAsText(int n, Locale locale) {
        throw this.unsupported();
    }

    public String getAsShortText(long l, Locale locale) {
        throw this.unsupported();
    }

    public String getAsShortText(int n, Locale locale) {
        throw this.unsupported();
    }

    public long add(long l, int n) {
        return this.getDurationField().add(l, n);
    }

    public long add(long l, long l2) {
        return this.getDurationField().add(l, l2);
    }

    public int getDifference(long l, long l2) {
        return this.getDurationField().getDifference(l, l2);
    }

    public long getDifferenceAsLong(long l, long l2) {
        return this.getDurationField().getDifferenceAsLong(l, l2);
    }

    public long set(long l, int n) {
        throw this.unsupported();
    }

    public long set(long l, String string, Locale locale) {
        throw this.unsupported();
    }

    public DurationField getDurationField() {
        return this.iDurationField;
    }

    public DurationField getRangeDurationField() {
        return null;
    }

    public boolean isLeap(long l) {
        throw this.unsupported();
    }

    public DurationField getLeapDurationField() {
        return null;
    }

    public int getMinimumValue() {
        throw this.unsupported();
    }

    public int getMaximumValue() {
        throw this.unsupported();
    }

    public int getMaximumValue(long l) {
        throw this.unsupported();
    }

    public int getMaximumTextLength(Locale locale) {
        throw this.unsupported();
    }

    public long roundFloor(long l) {
        throw this.unsupported();
    }

    public long roundCeiling(long l) {
        throw this.unsupported();
    }

    public long roundHalfFloor(long l) {
        throw this.unsupported();
    }

    public long roundHalfCeiling(long l) {
        throw this.unsupported();
    }

    public long roundHalfEven(long l) {
        throw this.unsupported();
    }

    public long remainder(long l) {
        throw this.unsupported();
    }

    public String toString() {
        return "UnsupportedDateTimeField";
    }

    private UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException(this.iType + " field is unsupported");
    }
}

