/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.field.FieldUtils;

public abstract class AbstractReadableInstantFieldProperty
implements Serializable {
    public abstract DateTimeField getField();

    public DateTimeFieldType getFieldType() {
        return this.getField().getType();
    }

    public String getName() {
        return this.getField().getName();
    }

    protected abstract long getMillis();

    protected Chronology getChronology() {
        throw new UnsupportedOperationException("The method getChronology() was added in v1.4 and needs to be implemented by subclasses of AbstractReadableInstantFieldProperty");
    }

    public int get() {
        return this.getField().get(this.getMillis());
    }

    public String getAsText(Locale locale) {
        return this.getField().getAsText(this.getMillis(), locale);
    }

    public String getAsShortText(Locale locale) {
        return this.getField().getAsShortText(this.getMillis(), locale);
    }

    public int getMinimumValueOverall() {
        return this.getField().getMinimumValue();
    }

    public int getMaximumValueOverall() {
        return this.getField().getMaximumValue();
    }

    public int getMaximumTextLength(Locale locale) {
        return this.getField().getMaximumTextLength(locale);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractReadableInstantFieldProperty)) {
            return false;
        }
        AbstractReadableInstantFieldProperty abstractReadableInstantFieldProperty = (AbstractReadableInstantFieldProperty)object;
        return this.get() == abstractReadableInstantFieldProperty.get() && this.getFieldType().equals(abstractReadableInstantFieldProperty.getFieldType()) && FieldUtils.equals(this.getChronology(), abstractReadableInstantFieldProperty.getChronology());
    }

    public int hashCode() {
        return this.get() * 17 + this.getFieldType().hashCode() + this.getChronology().hashCode();
    }

    public String toString() {
        return "Property[" + this.getName() + "]";
    }
}

