/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadablePeriod;
import org.joda.time.field.FieldUtils;

public class PeriodType
implements Serializable {
    private static final Map<PeriodType, Object> cTypes = new HashMap<PeriodType, Object>(32);
    static int YEAR_INDEX = 0;
    static int MONTH_INDEX = 1;
    static int WEEK_INDEX = 2;
    static int DAY_INDEX = 3;
    static int HOUR_INDEX = 4;
    static int MINUTE_INDEX = 5;
    static int SECOND_INDEX = 6;
    static int MILLI_INDEX = 7;
    private static PeriodType cStandard;
    private static PeriodType cTime;
    private final String iName;
    private final DurationFieldType[] iTypes;
    private final int[] iIndices;

    public static PeriodType standard() {
        PeriodType periodType = cStandard;
        if (periodType == null) {
            cStandard = periodType = new PeriodType("Standard", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.months(), DurationFieldType.weeks(), DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{0, 1, 2, 3, 4, 5, 6, 7});
        }
        return periodType;
    }

    public static PeriodType time() {
        PeriodType periodType = cTime;
        if (periodType == null) {
            cTime = periodType = new PeriodType("Time", new DurationFieldType[]{DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{-1, -1, -1, -1, 0, 1, 2, 3});
        }
        return periodType;
    }

    protected PeriodType(String string, DurationFieldType[] durationFieldTypeArray, int[] nArray) {
        this.iName = string;
        this.iTypes = durationFieldTypeArray;
        this.iIndices = nArray;
    }

    public String getName() {
        return this.iName;
    }

    public int size() {
        return this.iTypes.length;
    }

    public DurationFieldType getFieldType(int n) {
        return this.iTypes[n];
    }

    public boolean isSupported(DurationFieldType durationFieldType) {
        return this.indexOf(durationFieldType) >= 0;
    }

    public int indexOf(DurationFieldType durationFieldType) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.iTypes[i] != durationFieldType) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return "PeriodType[" + this.getName() + "]";
    }

    boolean addIndexedField(ReadablePeriod readablePeriod, int n, int[] nArray, int n2) {
        if (n2 == 0) {
            return false;
        }
        int n3 = this.iIndices[n];
        if (n3 == -1) {
            throw new UnsupportedOperationException("Field is not supported");
        }
        nArray[n3] = FieldUtils.safeAdd(nArray[n3], n2);
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PeriodType)) {
            return false;
        }
        PeriodType periodType = (PeriodType)object;
        return Arrays.equals(this.iTypes, periodType.iTypes);
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.iTypes.length; ++i) {
            n += this.iTypes[i].hashCode();
        }
        return n;
    }
}

