/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BasePeriod;

public final class Period
extends BasePeriod
implements Serializable,
ReadablePeriod {
    public static final Period ZERO = new Period();

    public static Period months(int n) {
        return new Period(new int[]{0, n, 0, 0, 0, 0, 0, 0}, PeriodType.standard());
    }

    public static Period days(int n) {
        return new Period(new int[]{0, 0, 0, n, 0, 0, 0, 0}, PeriodType.standard());
    }

    public Period() {
        super(0L, null, null);
    }

    private Period(int[] nArray, PeriodType periodType) {
        super(nArray, periodType);
    }

    public Period plusYears(int n) {
        if (n == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.YEAR_INDEX, nArray, n);
        return new Period(nArray, this.getPeriodType());
    }

    public Period plusMonths(int n) {
        if (n == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.MONTH_INDEX, nArray, n);
        return new Period(nArray, this.getPeriodType());
    }

    public Period plusDays(int n) {
        if (n == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.DAY_INDEX, nArray, n);
        return new Period(nArray, this.getPeriodType());
    }

    public Period plusMillis(int n) {
        if (n == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.MILLI_INDEX, nArray, n);
        return new Period(nArray, this.getPeriodType());
    }
}

