/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.buffer;

import java.nio.ByteOrder;
import org.jboss.netty.buffer.BigEndianHeapChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffer;

public final class ChannelBuffers {
    public static final ByteOrder BIG_ENDIAN = ByteOrder.BIG_ENDIAN;
    public static final ByteOrder LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;
    public static final ChannelBuffer EMPTY_BUFFER = new BigEndianHeapChannelBuffer(0);
    private static final char[] HEXDUMP_TABLE = new char[1024];

    public static int hashCode(ChannelBuffer buffer) {
        int i;
        int aLen = buffer.readableBytes();
        int intCount = aLen >>> 2;
        int byteCount = aLen & 3;
        int hashCode = 1;
        int arrayIndex = buffer.readerIndex();
        if (buffer.order() == BIG_ENDIAN) {
            for (i = intCount; i > 0; --i) {
                hashCode = 31 * hashCode + buffer.getInt(arrayIndex);
                arrayIndex += 4;
            }
        } else {
            for (i = intCount; i > 0; --i) {
                hashCode = 31 * hashCode + ChannelBuffers.swapInt(buffer.getInt(arrayIndex));
                arrayIndex += 4;
            }
        }
        for (i = byteCount; i > 0; --i) {
            hashCode = 31 * hashCode + buffer.getByte(arrayIndex++);
        }
        if (hashCode == 0) {
            hashCode = 1;
        }
        return hashCode;
    }

    public static boolean equals(ChannelBuffer bufferA, ChannelBuffer bufferB) {
        int i;
        int aLen = bufferA.readableBytes();
        if (aLen != bufferB.readableBytes()) {
            return false;
        }
        int longCount = aLen >>> 3;
        int byteCount = aLen & 7;
        int aIndex = bufferA.readerIndex();
        int bIndex = bufferB.readerIndex();
        if (bufferA.order() == bufferB.order()) {
            for (i = longCount; i > 0; --i) {
                if (bufferA.getLong(aIndex) != bufferB.getLong(bIndex)) {
                    return false;
                }
                aIndex += 8;
                bIndex += 8;
            }
        } else {
            for (i = longCount; i > 0; --i) {
                if (bufferA.getLong(aIndex) != ChannelBuffers.swapLong(bufferB.getLong(bIndex))) {
                    return false;
                }
                aIndex += 8;
                bIndex += 8;
            }
        }
        for (i = byteCount; i > 0; --i) {
            if (bufferA.getByte(aIndex) != bufferB.getByte(bIndex)) {
                return false;
            }
            ++aIndex;
            ++bIndex;
        }
        return true;
    }

    public static int compare(ChannelBuffer bufferA, ChannelBuffer bufferB) {
        long vb;
        long va;
        int i;
        int aLen = bufferA.readableBytes();
        int bLen = bufferB.readableBytes();
        int minLength = Math.min(aLen, bLen);
        int uintCount = minLength >>> 2;
        int byteCount = minLength & 3;
        int aIndex = bufferA.readerIndex();
        int bIndex = bufferB.readerIndex();
        if (bufferA.order() == bufferB.order()) {
            for (i = uintCount; i > 0; --i) {
                va = bufferA.getUnsignedInt(aIndex);
                if (va > (vb = bufferB.getUnsignedInt(bIndex))) {
                    return 1;
                }
                if (va < vb) {
                    return -1;
                }
                aIndex += 4;
                bIndex += 4;
            }
        } else {
            for (i = uintCount; i > 0; --i) {
                va = bufferA.getUnsignedInt(aIndex);
                if (va > (vb = (long)ChannelBuffers.swapInt(bufferB.getInt(bIndex)) & 0xFFFFFFFFL)) {
                    return 1;
                }
                if (va < vb) {
                    return -1;
                }
                aIndex += 4;
                bIndex += 4;
            }
        }
        for (i = byteCount; i > 0; --i) {
            short vb2;
            short va2 = bufferA.getUnsignedByte(aIndex);
            if (va2 > (vb2 = bufferB.getUnsignedByte(bIndex))) {
                return 1;
            }
            if (va2 < vb2) {
                return -1;
            }
            ++aIndex;
            ++bIndex;
        }
        return aLen - bLen;
    }

    public static short swapShort(short value) {
        return (short)(value << 8 | value >>> 8 & 0xFF);
    }

    public static int swapInt(int value) {
        return ChannelBuffers.swapShort((short)value) << 16 | ChannelBuffers.swapShort((short)(value >>> 16)) & 0xFFFF;
    }

    public static long swapLong(long value) {
        return (long)ChannelBuffers.swapInt((int)value) << 32 | (long)ChannelBuffers.swapInt((int)(value >>> 32)) & 0xFFFFFFFFL;
    }

    static {
        char[] DIGITS = "0123456789abcdef".toCharArray();
        for (int i = 0; i < 256; ++i) {
            ChannelBuffers.HEXDUMP_TABLE[i << 1] = DIGITS[i >>> 4 & 0xF];
            ChannelBuffers.HEXDUMP_TABLE[(i << 1) + 1] = DIGITS[i & 0xF];
        }
    }
}

