/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.buffer;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public abstract class AbstractChannelBuffer
implements ChannelBuffer {
    private int readerIndex;
    private int writerIndex;

    public int readerIndex() {
        return this.readerIndex;
    }

    public int writerIndex() {
        return this.writerIndex;
    }

    public void setIndex(int readerIndex, int writerIndex) {
        if (readerIndex < 0 || readerIndex > writerIndex || writerIndex > this.capacity()) {
            throw new IndexOutOfBoundsException("Invalid writerIndex: " + writerIndex + " - Maximum is " + readerIndex + " or " + this.capacity());
        }
        this.readerIndex = readerIndex;
        this.writerIndex = writerIndex;
    }

    public int readableBytes() {
        return this.writerIndex - this.readerIndex;
    }

    public short getUnsignedByte(int index) {
        return (short)(this.getByte(index) & 0xFF);
    }

    public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    public int hashCode() {
        return ChannelBuffers.hashCode(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChannelBuffer)) {
            return false;
        }
        return ChannelBuffers.equals(this, (ChannelBuffer)o);
    }

    public int compareTo(ChannelBuffer that) {
        return ChannelBuffers.compare(this, that);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + "ridx=" + this.readerIndex + ", " + "widx=" + this.writerIndex + ", " + "cap=" + this.capacity() + ')';
    }
}

