/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util14;

import java.nio.ByteOrder;

public class ConversionUtil {
    public static final String NATIVE_UTF16_CHARSET_NAME = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? "UTF-16BE" : "UTF-16LE";

    private ConversionUtil() {
    }

    public static String toStringFromByteArray(byte[] value, int radix) {
        assert (2 == radix || 16 == radix) : "Make sure that the algorithm below works for your radix";
        if (0 == value.length) {
            return "";
        }
        int trick = radix * radix;
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < value.length; ++i) {
            ret.append(Integer.toString(trick | 0xFF & value[i], radix).substring(1));
        }
        return ret.toString().toUpperCase();
    }
}

