/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util.property;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eigenbase.util.property.Property;
import org.eigenbase.util.property.Trigger;

public class TriggerableProperties
extends Properties {
    protected final Map triggers = new HashMap();
    protected final Map properties = new HashMap();

    protected TriggerableProperties() {
    }

    public synchronized Object setProperty(String key, String value) {
        Property property;
        String oldValue = super.getProperty(key);
        Object object = super.setProperty(key, value);
        if (oldValue == null && object != null) {
            oldValue = object.toString();
        }
        if ((property = (Property)this.properties.get(key)) != null && this.triggersAreEnabled()) {
            try {
                property.onChange(oldValue, value);
            }
            catch (Trigger.VetoRT vex) {
                this.superSetProperty(key, oldValue);
                try {
                    property.onChange(value, oldValue);
                }
                catch (Trigger.VetoRT ex) {
                    // empty catch block
                }
                throw vex;
            }
        }
        return oldValue;
    }

    public boolean triggersAreEnabled() {
        return true;
    }

    private void superSetProperty(String key, String oldValue) {
        if (oldValue != null) {
            super.setProperty(key, oldValue);
        }
    }

    static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o2 != null && o1.equals(o2);
    }

    public void register(Property property) {
        this.properties.put(property.getPath(), property);
    }
}

