/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util.property;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.eigenbase.util.property.Trigger;
import org.eigenbase.util.property.TriggerableProperties;

public abstract class Property {
    protected final Properties properties;
    private final String path;
    private final String defaultValue;
    private final TriggerList triggerList = new TriggerList();

    protected Property(Properties properties, String path, String defaultValue) {
        this.properties = properties;
        this.path = path;
        this.defaultValue = defaultValue;
        if (properties instanceof TriggerableProperties) {
            ((TriggerableProperties)properties).register(this);
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    protected String getInternal(String defaultValue, boolean required) {
        String value = this.properties.getProperty(this.path, defaultValue);
        if (value != null) {
            return value;
        }
        if (defaultValue == null && (value = this.getDefaultValue()) != null) {
            return value;
        }
        if (required) {
            throw new RuntimeException("Property " + this.path + " must be set");
        }
        return value;
    }

    public void onChange(String oldValue, String value) {
        if (TriggerableProperties.equals(oldValue, value)) {
            return;
        }
        this.triggerList.execute(this, value);
    }

    public boolean booleanValue() {
        String value = this.getInternal(null, false);
        if (value == null) {
            return false;
        }
        return Property.toBoolean(value);
    }

    public static boolean toBoolean(String value) {
        String trimmedLowerValue = value.toLowerCase().trim();
        return trimmedLowerValue.equals("1") || trimmedLowerValue.equals("true") || trimmedLowerValue.equals("yes");
    }

    public String stringValue() {
        return this.getInternal(null, false);
    }

    private static class TriggerList
    extends ArrayList {
        private TriggerList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void execute(Property property, String value) throws Trigger.VetoRT {
            ArrayList<Trigger> l = new ArrayList<Trigger>();
            Property property2 = property;
            synchronized (property2) {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    Trigger t = this.convert(it.next());
                    if (t == null) {
                        it.remove();
                        continue;
                    }
                    l.add(t);
                }
            }
            for (int i = 0; i < l.size(); ++i) {
                Trigger t = (Trigger)l.get(i);
                t.execute(property, value);
            }
        }

        private Trigger convert(Object o) {
            if (o instanceof WeakReference) {
                o = ((WeakReference)o).get();
            }
            return (Trigger)o;
        }
    }
}

