/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import com.google.common.collect.Iterators;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pair<T1, T2>
implements Serializable,
Comparable<Pair<T1, T2>>,
Map.Entry<T1, T2> {
    public final Object left;
    public final Object right;

    public Pair(Object left, Object right) {
        this.left = left;
        this.right = right;
    }

    public static <T1, T2> Pair<T1, T2> of(T1 left, T2 right) {
        return new Pair<T1, T2>(left, right);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Pair && Util.equal(this.left, ((Pair)obj).left) && Util.equal(this.right, ((Pair)obj).right);
    }

    @Override
    public int hashCode() {
        int h1 = Util.hash(0, this.left);
        return Util.hash(h1, this.right);
    }

    @Override
    public int compareTo(Pair<T1, T2> that) {
        int c = Pair.compare((Comparable)this.left, (Comparable)that.left);
        if (c == 0) {
            c = Pair.compare((Comparable)this.right, (Comparable)that.right);
        }
        return c;
    }

    public String toString() {
        return "<" + this.left + ", " + this.right + ">";
    }

    @Override
    public Object getKey() {
        return this.left;
    }

    @Override
    public Object getValue() {
        return this.right;
    }

    @Override
    public Object setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    private static <C extends Comparable<C>> int compare(C c1, C c2) {
        if (c1 == null) {
            if (c2 == null) {
                return 0;
            }
            return -1;
        }
        if (c2 == null) {
            return 1;
        }
        return c1.compareTo(c2);
    }

    public static <K, V> List<Pair<K, V>> zip(List<K> ks, List<V> vs) {
        return Pair.zip(ks, vs, false);
    }

    public static <K, V> List<Pair<K, V>> zip(final List<K> ks, final List<V> vs, boolean strict) {
        int size;
        if (strict) {
            if (ks.size() != vs.size()) {
                throw new AssertionError();
            }
            size = ks.size();
        } else {
            size = Math.min(ks.size(), vs.size());
        }
        return new AbstractList<Pair<K, V>>(){

            @Override
            public Pair<K, V> get(int index) {
                return Pair.of(ks.get(index), vs.get(index));
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public static <K, V> Iterable<Pair<K, V>> zip(final Iterable<K> ks, final Iterable<V> vs) {
        return new Iterable<Pair<K, V>>(){

            @Override
            public Iterator<Pair<K, V>> iterator() {
                final Iterator kIterator = ks.iterator();
                final Iterator vIterator = vs.iterator();
                return new Iterator<Pair<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return kIterator.hasNext() && vIterator.hasNext();
                    }

                    @Override
                    public Pair<K, V> next() {
                        return Pair.of(kIterator.next(), vIterator.next());
                    }

                    @Override
                    public void remove() {
                        kIterator.remove();
                        vIterator.remove();
                    }
                };
            }
        };
    }

    public static <K, V> List<Pair<K, V>> zip(final K[] ks, final V[] vs) {
        return new AbstractList<Pair<K, V>>(){

            @Override
            public Pair<K, V> get(int index) {
                return Pair.of(ks[index], vs[index]);
            }

            @Override
            public int size() {
                return Math.min(ks.length, vs.length);
            }
        };
    }

    public static <K, V> List<K> left(final List<? extends Map.Entry<K, V>> pairs) {
        return new AbstractList<K>(){

            @Override
            public Object get(int index) {
                return ((Map.Entry)pairs.get(index)).getKey();
            }

            @Override
            public int size() {
                return pairs.size();
            }
        };
    }

    public static <K, V> List<V> right(final List<? extends Map.Entry<K, V>> pairs) {
        return new AbstractList<V>(){

            @Override
            public Object get(int index) {
                return ((Map.Entry)pairs.get(index)).getValue();
            }

            @Override
            public int size() {
                return pairs.size();
            }
        };
    }

    public static <T> Iterable<Pair<T, T>> adjacents(final Iterable<T> iterable) {
        return new Iterable<Pair<T, T>>(){

            @Override
            public Iterator<Pair<T, T>> iterator() {
                final Iterator iterator = iterable.iterator();
                if (!iterator.hasNext()) {
                    return Iterators.emptyIterator();
                }
                final Object first = iterator.next();
                return new Iterator<Pair<T, T>>(){
                    Object previous;
                    {
                        this.previous = first;
                    }

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Pair<T, T> next() {
                        Object current = iterator.next();
                        Pair pair = Pair.of(this.previous, current);
                        this.previous = current;
                        return pair;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        };
    }
}

