/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.hydromatic.optiq.runtime.FlatLists;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableIntList
extends FlatLists.AbstractFlatList<Integer> {
    private final int[] ints;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final ImmutableIntList EMPTY = new EmptyImmutableIntList();

    private ImmutableIntList(int ... ints) {
        this.ints = ints;
    }

    public static ImmutableIntList of(int ... ints) {
        return new ImmutableIntList((int[])ints.clone());
    }

    public static ImmutableIntList copyOf(Collection<? extends Number> list) {
        if (list instanceof ImmutableIntList) {
            return (ImmutableIntList)list;
        }
        if (list.isEmpty()) {
            return EMPTY;
        }
        int[] ints = new int[list.size()];
        int i = 0;
        for (Number number : list) {
            ints[i++] = number.intValue();
        }
        return new ImmutableIntList(ints);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.ints);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof ImmutableIntList && Arrays.equals(this.ints, ((ImmutableIntList)obj).ints) || obj instanceof List && obj.equals(this);
    }

    public String toString() {
        return Arrays.toString(this.ints);
    }

    @Override
    public boolean isEmpty() {
        return this.ints.length == 0;
    }

    @Override
    public int size() {
        return this.ints.length;
    }

    @Override
    public Object[] toArray() {
        Object[] objects = new Object[this.ints.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = this.ints[i];
        }
        return objects;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.ints.length;
        if (a.length < size) {
            Object[] objectArray = a = a.getClass() == Object[].class ? new Object[size] : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        if (a.getClass() == Integer[].class) {
            Integer[] integers = (Integer[])a;
            for (int i = 0; i < integers.length; ++i) {
                integers[i] = this.ints[i];
            }
        } else {
            System.arraycopy(this.toArray(), 0, a, 0, size);
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public Integer get(int index) {
        return this.ints[index];
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Integer) {
            int seek = (Integer)o;
            for (int i = 0; i < this.ints.length; ++i) {
                if (this.ints[i] != seek) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof Integer) {
            int seek = (Integer)o;
            for (int i = this.ints.length - 1; i >= 0; --i) {
                if (this.ints[i] != seek) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyImmutableIntList
    extends ImmutableIntList {
        private EmptyImmutableIntList() {
            super(new int[0]);
        }

        @Override
        public Object[] toArray() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
    }
}

