/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql2rel;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.SqlBinaryOperator;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlDataTypeSpec;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlIntervalLiteral;
import org.eigenbase.sql.SqlIntervalQualifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNumericLiteral;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.fun.SqlAvgAggFunction;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql2rel.ReflectiveConvertletTable;
import org.eigenbase.sql2rel.SqlRexContext;
import org.eigenbase.sql2rel.SqlRexConvertlet;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardConvertletTable
extends ReflectiveConvertletTable {
    public static final StandardConvertletTable INSTANCE = new StandardConvertletTable();

    private StandardConvertletTable() {
        this.addAlias(SqlStdOperatorTable.CHARACTER_LENGTH, SqlStdOperatorTable.CHAR_LENGTH);
        this.addAlias(SqlStdOperatorTable.IS_UNKNOWN, SqlStdOperatorTable.IS_NULL);
        this.addAlias(SqlStdOperatorTable.IS_NOT_UNKNOWN, SqlStdOperatorTable.IS_NOT_NULL);
        this.registerOp(SqlStdOperatorTable.CAST, new SqlRexConvertlet(){

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                return StandardConvertletTable.this.convertCast(cx, call);
            }
        });
        this.registerOp(SqlStdOperatorTable.IS_DISTINCT_FROM, new SqlRexConvertlet(){

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                return StandardConvertletTable.this.convertIsDistinctFrom(cx, call, false);
            }
        });
        this.registerOp(SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, new SqlRexConvertlet(){

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                return StandardConvertletTable.this.convertIsDistinctFrom(cx, call, true);
            }
        });
        this.registerOp(SqlStdOperatorTable.NOT_LIKE, new SqlRexConvertlet(){

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                SqlCall expanded = SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, SqlStdOperatorTable.LIKE.createCall(SqlParserPos.ZERO, call.getOperandList()));
                return cx.convertExpression(expanded);
            }
        });
        this.registerOp(SqlStdOperatorTable.NOT_SIMILAR_TO, new SqlRexConvertlet(){

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                SqlCall expanded = SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, SqlStdOperatorTable.SIMILAR_TO.createCall(SqlParserPos.ZERO, call.getOperandList()));
                return cx.convertExpression(expanded);
            }
        });
        this.registerOp(SqlStdOperatorTable.UNARY_PLUS, new SqlRexConvertlet(){

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                Object expanded = call.operand(0);
                return cx.convertExpression((SqlNode)expanded);
            }
        });
        this.registerOp(SqlStdOperatorTable.AS, new SqlRexConvertlet(){

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                Object expanded = call.operand(0);
                return cx.convertExpression((SqlNode)expanded);
            }
        });
        this.registerOp(SqlStdOperatorTable.SQRT, new SqlRexConvertlet(){

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                SqlCall expanded = SqlStdOperatorTable.POWER.createCall(SqlParserPos.ZERO, new SqlNode[]{call.operand(0), SqlLiteral.createExactNumeric("0.5", SqlParserPos.ZERO)});
                return cx.convertExpression(expanded);
            }
        });
        this.registerOp(SqlStdOperatorTable.AVG, new AvgVarianceConvertlet(SqlAvgAggFunction.Subtype.AVG));
        this.registerOp(SqlStdOperatorTable.STDDEV_POP, new AvgVarianceConvertlet(SqlAvgAggFunction.Subtype.STDDEV_POP));
        this.registerOp(SqlStdOperatorTable.STDDEV_SAMP, new AvgVarianceConvertlet(SqlAvgAggFunction.Subtype.STDDEV_SAMP));
        this.registerOp(SqlStdOperatorTable.VAR_POP, new AvgVarianceConvertlet(SqlAvgAggFunction.Subtype.VAR_POP));
        this.registerOp(SqlStdOperatorTable.VAR_SAMP, new AvgVarianceConvertlet(SqlAvgAggFunction.Subtype.VAR_SAMP));
        this.registerOp(SqlStdOperatorTable.FLOOR, new FloorCeilConvertlet(true));
        this.registerOp(SqlStdOperatorTable.CEIL, new FloorCeilConvertlet(false));
    }

    protected RexNode convertCast(SqlRexContext cx, SqlCall call) {
        RelDataTypeFactory typeFactory = cx.getTypeFactory();
        assert (call.getKind() == SqlKind.CAST);
        Object left = call.operand(0);
        Object right = call.operand(1);
        if (right instanceof SqlIntervalQualifier) {
            SqlIntervalQualifier intervalQualifier = (SqlIntervalQualifier)right;
            if (left instanceof SqlIntervalLiteral || left instanceof SqlNumericLiteral) {
                RexLiteral sourceInterval = (RexLiteral)cx.convertExpression((SqlNode)left);
                BigDecimal sourceValue = (BigDecimal)sourceInterval.getValue();
                RexLiteral castedInterval = cx.getRexBuilder().makeIntervalLiteral(sourceValue.multiply(BigDecimal.valueOf(intervalQualifier.getStartUnit().multiplier), MathContext.UNLIMITED), intervalQualifier);
                return this.castToValidatedType(cx, call, castedInterval);
            }
            return this.castToValidatedType(cx, call, cx.convertExpression((SqlNode)left));
        }
        SqlDataTypeSpec dataType = (SqlDataTypeSpec)right;
        if (SqlUtil.isNullLiteral(left, false)) {
            return cx.convertExpression((SqlNode)left);
        }
        RexNode arg = cx.convertExpression((SqlNode)left);
        RelDataType type = dataType.deriveType(typeFactory);
        if (arg.getType().isNullable()) {
            type = typeFactory.createTypeWithNullability(type, true);
        }
        if (null != dataType.getCollectionsTypeName()) {
            RelDataType argComponentType = arg.getType().getComponentType();
            RelDataType componentType = type.getComponentType();
            if (argComponentType.isStruct() && !componentType.isStruct()) {
                RelDataType tt = typeFactory.builder().add(argComponentType.getFieldList().get(0).getName(), componentType).build();
                tt = typeFactory.createTypeWithNullability(tt, componentType.isNullable());
                boolean isn = type.isNullable();
                type = typeFactory.createMultisetType(tt, -1L);
                type = typeFactory.createTypeWithNullability(type, isn);
            }
        }
        return cx.getRexBuilder().makeCast(type, arg);
    }

    protected RexNode convertFloorCeil(SqlRexContext cx, SqlCall call, boolean floor) {
        if (call.operandCount() == 1 && call.operand(0) instanceof SqlIntervalLiteral) {
            RexNode mult;
            SqlIntervalLiteral literal = (SqlIntervalLiteral)call.operand(0);
            SqlIntervalLiteral.IntervalValue interval = (SqlIntervalLiteral.IntervalValue)literal.getValue();
            long val = interval.getIntervalQualifier().getStartUnit().multiplier;
            RexNode rexInterval = cx.convertExpression(literal);
            RexBuilder rexBuilder = cx.getRexBuilder();
            RexLiteral zero = rexBuilder.makeExactLiteral(BigDecimal.valueOf(0L));
            RexNode cond = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, rexInterval, zero);
            RexLiteral pad = rexBuilder.makeExactLiteral(BigDecimal.valueOf(val - 1L));
            RexNode cast = rexBuilder.makeReinterpretCast(rexInterval.getType(), pad, rexBuilder.makeLiteral(false));
            SqlBinaryOperator op = floor ? SqlStdOperatorTable.MINUS : SqlStdOperatorTable.PLUS;
            RexNode sum = rexBuilder.makeCall((SqlOperator)op, rexInterval, cast);
            RexNode kase = floor ? rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, cond, rexInterval, sum) : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, cond, sum, rexInterval);
            RexLiteral factor = rexBuilder.makeExactLiteral(BigDecimal.valueOf(val));
            RexNode div = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE_INTEGER, kase, factor);
            RexNode res = mult = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, div, factor);
            return res;
        }
        return this.convertFunction(cx, (SqlFunction)call.getOperator(), call);
    }

    public RexNode convertFunction(SqlRexContext cx, SqlFunction fun, SqlCall call) {
        List<SqlNode> operands = call.getOperandList();
        List<RexNode> exprs = StandardConvertletTable.convertExpressionList(cx, operands);
        if (fun.getFunctionType() == SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR) {
            return StandardConvertletTable.makeConstructorCall(cx, fun, exprs);
        }
        return cx.getRexBuilder().makeCall((SqlOperator)fun, exprs);
    }

    private static RexNode makeConstructorCall(SqlRexContext cx, SqlFunction constructor, List<RexNode> exprs) {
        RexBuilder rexBuilder = cx.getRexBuilder();
        RelDataTypeFactory typeFactory = cx.getTypeFactory();
        RelDataType type = rexBuilder.deriveReturnType(constructor, typeFactory, exprs);
        int n = type.getFieldCount();
        ImmutableList.Builder initializationExprs = ImmutableList.builder();
        for (int i = 0; i < n; ++i) {
            initializationExprs.add(cx.getDefaultValueFactory().newAttributeInitializer(type, constructor, i, exprs));
        }
        List<RexNode> defaultCasts = RexUtil.generateCastExpressions(rexBuilder, type, initializationExprs.build());
        return rexBuilder.makeNewInvocation(type, defaultCasts);
    }

    private static List<RexNode> convertExpressionList(SqlRexContext cx, List<SqlNode> nodes) {
        ArrayList<RexNode> exprs = new ArrayList<RexNode>();
        for (SqlNode node : nodes) {
            exprs.add(cx.convertExpression(node));
        }
        return exprs;
    }

    private RexNode convertIsDistinctFrom(SqlRexContext cx, SqlCall call, boolean neg) {
        RexNode op0 = cx.convertExpression((SqlNode)call.operand(0));
        RexNode op1 = cx.convertExpression((SqlNode)call.operand(1));
        return RelOptUtil.isDistinctFrom(cx.getRexBuilder(), op0, op1, neg);
    }

    public RexNode castToValidatedType(SqlRexContext cx, SqlCall call, RexNode value) {
        RelDataType resType = cx.getValidator().getValidatedNodeType(call);
        if (value.getType() == resType) {
            return value;
        }
        return cx.getRexBuilder().makeCast(resType, value);
    }

    private class FloorCeilConvertlet
    implements SqlRexConvertlet {
        private final boolean floor;

        public FloorCeilConvertlet(boolean floor) {
            this.floor = floor;
        }

        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            return StandardConvertletTable.this.convertFloorCeil(cx, call, this.floor);
        }
    }

    private static class AvgVarianceConvertlet
    implements SqlRexConvertlet {
        private final SqlAvgAggFunction.Subtype subtype;

        public AvgVarianceConvertlet(SqlAvgAggFunction.Subtype subtype) {
            this.subtype = subtype;
        }

        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            SqlNode expr;
            assert (call.operandCount() == 1);
            Object arg = call.operand(0);
            switch (this.subtype) {
                case AVG: {
                    expr = this.expandAvg((SqlNode)arg);
                    break;
                }
                case STDDEV_POP: {
                    expr = this.expandVariance((SqlNode)arg, true, true);
                    break;
                }
                case STDDEV_SAMP: {
                    expr = this.expandVariance((SqlNode)arg, false, true);
                    break;
                }
                case VAR_POP: {
                    expr = this.expandVariance((SqlNode)arg, true, false);
                    break;
                }
                case VAR_SAMP: {
                    expr = this.expandVariance((SqlNode)arg, false, false);
                    break;
                }
                default: {
                    throw Util.unexpected(this.subtype);
                }
            }
            RelDataType type = cx.getValidator().getValidatedNodeType(call);
            RexNode rex = cx.convertExpression(expr);
            return cx.getRexBuilder().ensureType(type, rex, true);
        }

        private SqlNode expandAvg(SqlNode arg) {
            SqlParserPos pos = SqlParserPos.ZERO;
            SqlCall sum = SqlStdOperatorTable.SUM.createCall(pos, arg);
            SqlCall count = SqlStdOperatorTable.COUNT.createCall(pos, arg);
            return SqlStdOperatorTable.DIVIDE.createCall(pos, sum, count);
        }

        private SqlNode expandVariance(SqlNode arg, boolean biased, boolean sqrt) {
            SqlCall div;
            SqlCall denominator;
            SqlParserPos pos = SqlParserPos.ZERO;
            SqlCall argSquared = SqlStdOperatorTable.MULTIPLY.createCall(pos, arg, arg);
            SqlCall sumArgSquared = SqlStdOperatorTable.SUM.createCall(pos, argSquared);
            SqlCall sum = SqlStdOperatorTable.SUM.createCall(pos, arg);
            SqlCall sumSquared = SqlStdOperatorTable.MULTIPLY.createCall(pos, sum, sum);
            SqlCall count = SqlStdOperatorTable.COUNT.createCall(pos, arg);
            SqlCall avgSumSquared = SqlStdOperatorTable.DIVIDE.createCall(pos, sumSquared, count);
            SqlCall diff = SqlStdOperatorTable.MINUS.createCall(pos, sumArgSquared, avgSumSquared);
            if (biased) {
                denominator = count;
            } else {
                SqlNumericLiteral one = SqlLiteral.createExactNumeric("1", pos);
                denominator = SqlStdOperatorTable.MINUS.createCall(pos, count, one);
            }
            SqlCall result = div = SqlStdOperatorTable.DIVIDE.createCall(pos, diff, denominator);
            if (sqrt) {
                SqlNumericLiteral half = SqlLiteral.createExactNumeric("0.5", pos);
                result = SqlStdOperatorTable.POWER.createCall(pos, div, half);
            }
            return result;
        }
    }
}

