/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql2rel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.CorrelatorRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelVisitor;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.util.ReflectUtil;
import org.eigenbase.util.ReflectiveVisitDispatcher;
import org.eigenbase.util.ReflectiveVisitor;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelStructuredTypeFlattener
implements ReflectiveVisitor {
    private final RexBuilder rexBuilder;
    private final RewriteRelVisitor visitor;
    private Map<RelNode, RelNode> oldToNewRelMap;
    private RelNode currentRel;
    private int iRestructureInput;
    private RelDataType flattenedRootType;
    boolean restructured;
    private final RelOptTable.ToRelContext toRelContext;

    public RelStructuredTypeFlattener(RexBuilder rexBuilder, RelOptTable.ToRelContext toRelContext) {
        this.rexBuilder = rexBuilder;
        this.visitor = new RewriteRelVisitor();
        this.toRelContext = toRelContext;
    }

    public void updateRelInMap(Map<RelNode, SortedSet<CorrelatorRel.Correlation>> mapRefRelToCorVar) {
        HashSet<RelNode> oldRefRelSet = new HashSet<RelNode>();
        oldRefRelSet.addAll(mapRefRelToCorVar.keySet());
        for (RelNode rel : oldRefRelSet) {
            if (!this.oldToNewRelMap.containsKey(rel)) continue;
            TreeSet corVarSet = new TreeSet();
            corVarSet.addAll(mapRefRelToCorVar.get(rel));
            mapRefRelToCorVar.remove(rel);
            mapRefRelToCorVar.put(this.oldToNewRelMap.get(rel), corVarSet);
        }
    }

    public void updateRelInMap(SortedMap<CorrelatorRel.Correlation, CorrelatorRel> mapCorVarToCorRel) {
        for (CorrelatorRel.Correlation corVar : mapCorVarToCorRel.keySet()) {
            CorrelatorRel oldRel = (CorrelatorRel)mapCorVarToCorRel.get(corVar);
            if (!this.oldToNewRelMap.containsKey(oldRel)) continue;
            RelNode newRel = this.oldToNewRelMap.get(oldRel);
            assert (newRel instanceof CorrelatorRel);
            mapCorVarToCorRel.put(corVar, (CorrelatorRel)newRel);
        }
    }

    public RelNode rewrite(RelNode root, boolean restructure) {
        this.oldToNewRelMap = new HashMap<RelNode, RelNode>();
        this.visitor.visit(root, 0, null);
        RelNode flattened = this.getNewForOldRel(root);
        this.flattenedRootType = flattened.getRowType();
        this.restructured = false;
        List<RexNode> structuringExps = null;
        if (restructure) {
            this.iRestructureInput = 0;
            structuringExps = this.restructureFields(root.getRowType());
        }
        if (this.restructured) {
            return CalcRel.createProject(flattened, structuringExps, root.getRowType().getFieldNames());
        }
        return flattened;
    }

    private List<RexNode> restructureFields(RelDataType structuredType) {
        ArrayList<RexNode> structuringExps = new ArrayList<RexNode>();
        for (RelDataTypeField field : structuredType.getFieldList()) {
            if (field.getType().getSqlTypeName() == SqlTypeName.STRUCTURED) {
                this.restructured = true;
                structuringExps.add(this.restructure(field.getType()));
                continue;
            }
            structuringExps.add(new RexInputRef(this.iRestructureInput, field.getType()));
            ++this.iRestructureInput;
        }
        return structuringExps;
    }

    private RexNode restructure(RelDataType structuredType) {
        RexInputRef nullIndicator = RexInputRef.of(this.iRestructureInput++, this.flattenedRootType.getFieldList());
        List<RexNode> inputExprs = this.restructureFields(structuredType);
        RexNode newInvocation = this.rexBuilder.makeNewInvocation(structuredType, inputExprs);
        if (!structuredType.isNullable()) {
            return newInvocation;
        }
        RexNode[] caseOperands = new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, nullIndicator), this.rexBuilder.makeCast(structuredType, this.rexBuilder.constantNull()), newInvocation};
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, caseOperands);
    }

    protected void setNewForOldRel(RelNode oldRel, RelNode newRel) {
        this.oldToNewRelMap.put(oldRel, newRel);
    }

    protected RelNode getNewForOldRel(RelNode oldRel) {
        return this.oldToNewRelMap.get(oldRel);
    }

    protected int getNewForOldInput(int oldOrdinal) {
        assert (this.currentRel != null);
        int newOrdinal = 0;
        RelNode oldInput = null;
        for (RelNode oldInput1 : this.currentRel.getInputs()) {
            RelDataType oldInputType = oldInput1.getRowType();
            int n = oldInputType.getFieldCount();
            if (oldOrdinal < n) {
                oldInput = oldInput1;
                break;
            }
            RelNode newInput = this.getNewForOldRel(oldInput1);
            newOrdinal += newInput.getRowType().getFieldCount();
            oldOrdinal -= n;
        }
        assert (oldInput != null);
        RelDataType oldInputType = oldInput.getRowType();
        return newOrdinal += this.calculateFlattenedOffset(oldInputType, oldOrdinal);
    }

    private int calculateFlattenedOffset(RelDataType rowType, int ordinal) {
        int offset = 0;
        if (SqlTypeUtil.needsNullIndicator(rowType)) {
            ++offset;
        }
        List<RelDataTypeField> oldFields = rowType.getFieldList();
        for (int i = 0; i < ordinal; ++i) {
            RelDataType oldFieldType = oldFields.get(i).getType();
            if (oldFieldType.isStruct()) {
                RelDataType flattened = SqlTypeUtil.flattenRecordType(this.rexBuilder.getTypeFactory(), oldFieldType, null);
                List<RelDataTypeField> fields = flattened.getFieldList();
                offset += fields.size();
                continue;
            }
            ++offset;
        }
        return offset;
    }

    public void rewriteGeneric(RelNode rel) {
        RelNode newRel = rel.copy(rel.getTraitSet(), rel.getInputs());
        List<RelNode> oldInputs = rel.getInputs();
        for (int i = 0; i < oldInputs.size(); ++i) {
            newRel.replaceInput(i, this.getNewForOldRel(oldInputs.get(i)));
        }
        this.setNewForOldRel(rel, newRel);
    }

    private class RewriteRelVisitor
    extends RelVisitor {
        private final ReflectiveVisitDispatcher<RelStructuredTypeFlattener, RelNode> dispatcher = ReflectUtil.createDispatcher(RelStructuredTypeFlattener.class, RelNode.class);

        private RewriteRelVisitor() {
        }

        public void visit(RelNode p, int ordinal, RelNode parent) {
            super.visit(p, ordinal, parent);
            RelStructuredTypeFlattener.this.currentRel = p;
            String visitMethodName = "rewriteRel";
            boolean found = this.dispatcher.invokeVisitor(RelStructuredTypeFlattener.this, RelStructuredTypeFlattener.this.currentRel, "rewriteRel");
            RelStructuredTypeFlattener.this.currentRel = null;
            if (!found && p.getInputs().size() == 0) {
                RelStructuredTypeFlattener.this.rewriteGeneric(p);
            }
            if (!found) {
                throw Util.newInternal("no 'rewriteRel' method found for class " + p.getClass().getName());
            }
        }
    }
}

