/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql2rel;

import java.util.BitSet;
import java.util.Collections;
import java.util.Set;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.RelNode;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.util.Pair;
import org.eigenbase.util.ReflectUtil;
import org.eigenbase.util.ReflectiveVisitor;
import org.eigenbase.util.Util;
import org.eigenbase.util.mapping.Mapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelFieldTrimmer
implements ReflectiveVisitor {
    private final ReflectUtil.MethodDispatcher<TrimResult> trimFieldsDispatcher;

    public RelFieldTrimmer(SqlValidator validator) {
        Util.discard(validator);
        this.trimFieldsDispatcher = ReflectUtil.createMethodDispatcher(TrimResult.class, this, "trimFields", RelNode.class, BitSet.class, Set.class);
    }

    public RelNode trim(RelNode root) {
        int fieldCount = root.getRowType().getFieldCount();
        BitSet fieldsUsed = BitSets.range(fieldCount);
        Set<RelDataTypeField> extraFields = Collections.emptySet();
        TrimResult trimResult = this.dispatchTrimFields(root, fieldsUsed, extraFields);
        if (!((Mapping)trimResult.right).isIdentity()) {
            throw new IllegalArgumentException();
        }
        return (RelNode)trimResult.left;
    }

    protected final TrimResult dispatchTrimFields(RelNode rel, BitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        TrimResult trimResult = this.trimFieldsDispatcher.invoke(rel, fieldsUsed, extraFields);
        RelNode newRel = (RelNode)trimResult.left;
        Mapping mapping = (Mapping)trimResult.right;
        int fieldCount = rel.getRowType().getFieldCount();
        assert (mapping.getSourceCount() == fieldCount) : "source: " + mapping.getSourceCount() + " != " + fieldCount;
        int newFieldCount = newRel.getRowType().getFieldCount();
        assert (mapping.getTargetCount() + extraFields.size() == newFieldCount) : "target: " + mapping.getTargetCount() + " + " + extraFields.size() + " != " + newFieldCount;
        if (newRel.equals(rel)) {
            return new TrimResult(rel, mapping);
        }
        return trimResult;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TrimResult
    extends Pair<RelNode, Mapping> {
        public TrimResult(RelNode left, Mapping right) {
            super(left, right);
        }
    }
}

