/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql2rel;

import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.logging.Logger;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.linq4j.function.Function2;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.CorrelatorRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelVisitor;
import org.eigenbase.rel.metadata.RelMdUtil;
import org.eigenbase.rel.rules.PushFilterPastJoinRule;
import org.eigenbase.relopt.Context;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCostImpl;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.hep.HepPlanner;
import org.eigenbase.relopt.hep.HepProgram;
import org.eigenbase.relopt.hep.HepRelVertex;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexShuttle;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlCountAggFunction;
import org.eigenbase.sql.fun.SqlSingleValueAggFunction;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.trace.EigenbaseTrace;
import org.eigenbase.util.Pair;
import org.eigenbase.util.ReflectUtil;
import org.eigenbase.util.ReflectiveVisitDispatcher;
import org.eigenbase.util.ReflectiveVisitor;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelDecorrelator
implements ReflectiveVisitor {
    private static final Logger SQL2REL_LOGGER = EigenbaseTrace.getSqlToRelTracer();
    private final Map<RelNode, SortedSet<CorrelatorRel.Correlation>> mapRefRelToCorVar;
    private final SortedMap<CorrelatorRel.Correlation, CorrelatorRel> mapCorVarToCorRel;
    private final Map<RexFieldAccess, CorrelatorRel.Correlation> mapFieldAccessToCorVar;
    private final DecorrelateRelVisitor decorrelateVisitor;
    private final RexBuilder rexBuilder;
    private RelNode currentRel;
    private final Context context;
    private final Map<RelNode, RelNode> mapOldToNewRel;
    private final Map<RelNode, SortedMap<CorrelatorRel.Correlation, Integer>> mapNewRelToMapCorVarToOutputPos;
    private final Map<RelNode, Map<Integer, Integer>> mapNewRelToMapOldToNewOutputPos;
    private final HashSet<CorrelatorRel> generatedCorRels = new HashSet();

    public RelDecorrelator(RexBuilder rexBuilder, Map<RelNode, SortedSet<CorrelatorRel.Correlation>> mapRefRelToCorVar, SortedMap<CorrelatorRel.Correlation, CorrelatorRel> mapCorVarToCorRel, Map<RexFieldAccess, CorrelatorRel.Correlation> mapFieldAccessToCorVar, Context context) {
        this.rexBuilder = rexBuilder;
        this.mapRefRelToCorVar = mapRefRelToCorVar;
        this.mapCorVarToCorRel = mapCorVarToCorRel;
        this.mapFieldAccessToCorVar = mapFieldAccessToCorVar;
        this.context = context;
        this.decorrelateVisitor = new DecorrelateRelVisitor();
        this.mapOldToNewRel = new HashMap<RelNode, RelNode>();
        this.mapNewRelToMapCorVarToOutputPos = new HashMap<RelNode, SortedMap<CorrelatorRel.Correlation, Integer>>();
        this.mapNewRelToMapOldToNewOutputPos = new HashMap<RelNode, Map<Integer, Integer>>();
    }

    public RelNode decorrelate(RelNode root) {
        HepProgram program = HepProgram.builder().addRuleInstance(new AdjustProjectForCountAggregateRule(false)).addRuleInstance(new AdjustProjectForCountAggregateRule(true)).build();
        HepPlanner planner = this.createPlanner(program);
        planner.setRoot(root);
        root = planner.findBestExp();
        this.mapOldToNewRel.clear();
        this.mapNewRelToMapCorVarToOutputPos.clear();
        this.mapNewRelToMapOldToNewOutputPos.clear();
        this.decorrelateVisitor.visit(root, 0, null);
        if (this.mapOldToNewRel.containsKey(root)) {
            return this.mapOldToNewRel.get(root);
        }
        return root;
    }

    private Function2<RelNode, RelNode, Void> createCopyHook() {
        return new Function2<RelNode, RelNode, Void>(){

            public Void apply(RelNode oldNode, RelNode newNode) {
                if (RelDecorrelator.this.mapRefRelToCorVar.containsKey(oldNode)) {
                    RelDecorrelator.this.mapRefRelToCorVar.put(newNode, RelDecorrelator.this.mapRefRelToCorVar.get(oldNode));
                }
                if (oldNode instanceof CorrelatorRel && newNode instanceof CorrelatorRel) {
                    CorrelatorRel oldCor = (CorrelatorRel)oldNode;
                    for (CorrelatorRel.Correlation c : oldCor.getCorrelations()) {
                        if (RelDecorrelator.this.mapCorVarToCorRel.get(c) != oldNode) continue;
                        RelDecorrelator.this.mapCorVarToCorRel.put(c, (CorrelatorRel)newNode);
                    }
                    if (RelDecorrelator.this.generatedCorRels.contains(oldNode)) {
                        RelDecorrelator.this.generatedCorRels.add((CorrelatorRel)newNode);
                    }
                }
                return null;
            }
        };
    }

    private HepPlanner createPlanner(HepProgram program) {
        return new HepPlanner(program, this.context, true, this.createCopyHook(), RelOptCostImpl.FACTORY);
    }

    public RelNode removeCorrelationViaRule(RelNode root) {
        HepProgram program = HepProgram.builder().addRuleInstance(new RemoveSingleAggregateRule()).addRuleInstance(new RemoveCorrelationForScalarProjectRule()).addRuleInstance(new RemoveCorrelationForScalarAggregateRule()).addRuleInstance(PushFilterPastJoinRule.FILTER_ON_JOIN).build();
        HepPlanner planner = this.createPlanner(program);
        planner.setRoot(root);
        RelNode newRootRel = planner.findBestExp();
        return newRootRel;
    }

    protected RexNode removeCorrelationExpr(RexNode exp, boolean projectPulledAboveLeftCorrelator) {
        RemoveCorrelationRexShuttle shuttle = new RemoveCorrelationRexShuttle(this.rexBuilder, projectPulledAboveLeftCorrelator);
        return exp.accept(shuttle);
    }

    protected RexNode removeCorrelationExpr(RexNode exp, boolean projectPulledAboveLeftCorrelator, RexInputRef nullIndicator) {
        RemoveCorrelationRexShuttle shuttle = new RemoveCorrelationRexShuttle(this.rexBuilder, projectPulledAboveLeftCorrelator, nullIndicator);
        return exp.accept(shuttle);
    }

    protected RexNode removeCorrelationExpr(RexNode exp, boolean projectPulledAboveLeftCorrelator, Set<Integer> isCount) {
        RemoveCorrelationRexShuttle shuttle = new RemoveCorrelationRexShuttle(this.rexBuilder, projectPulledAboveLeftCorrelator, isCount);
        return exp.accept(shuttle);
    }

    public void decorrelateRelGeneric(RelNode rel) {
        RelNode newRel = rel.copy(rel.getTraitSet(), rel.getInputs());
        if (rel.getInputs().size() > 0) {
            List<RelNode> oldInputs = rel.getInputs();
            ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
            for (int i = 0; i < oldInputs.size(); ++i) {
                RelNode newInputRel = this.mapOldToNewRel.get(oldInputs.get(i));
                if (newInputRel == null || this.mapNewRelToMapCorVarToOutputPos.containsKey(newInputRel)) {
                    return;
                }
                newInputs.add(newInputRel);
                newRel.replaceInput(i, newInputRel);
            }
            if (!Util.equalShallow(oldInputs, newInputs)) {
                newRel = rel.copy(rel.getTraitSet(), newInputs);
            }
        }
        HashMap<Integer, Integer> mapOldToNewOutputPos = new HashMap<Integer, Integer>();
        for (int i = 0; i < rel.getRowType().getFieldCount(); ++i) {
            mapOldToNewOutputPos.put(i, i);
        }
        this.mapOldToNewRel.put(rel, newRel);
        this.mapNewRelToMapOldToNewOutputPos.put(newRel, mapOldToNewOutputPos);
    }

    private RelNode projectJoinOutputWithNullability(JoinRel joinRel, ProjectRel projRel, int nullIndicatorPos) {
        RelDataTypeFactory typeFactory = joinRel.getCluster().getTypeFactory();
        RelNode leftInputRel = joinRel.getLeft();
        JoinRelType joinType = joinRel.getJoinType();
        RexInputRef nullIndicator = new RexInputRef(nullIndicatorPos, typeFactory.createTypeWithNullability(joinRel.getRowType().getFieldList().get(nullIndicatorPos).getType(), true));
        ArrayList<Pair<RexNode, String>> newProjExprs = new ArrayList<Pair<RexNode, String>>();
        List<RelDataTypeField> leftInputFields = leftInputRel.getRowType().getFieldList();
        for (int i = 0; i < leftInputFields.size(); ++i) {
            newProjExprs.add(RexInputRef.of2(i, leftInputFields));
        }
        boolean projectPulledAboveLeftCorrelator = joinType.generatesNullsOnRight();
        for (Pair<RexNode, String> pair : projRel.getNamedProjects()) {
            RexNode newProjExpr = this.removeCorrelationExpr((RexNode)pair.left, projectPulledAboveLeftCorrelator, nullIndicator);
            newProjExprs.add(Pair.of(newProjExpr, pair.right));
        }
        RelNode newProjRel = CalcRel.createProject((RelNode)joinRel, newProjExprs, false);
        return newProjRel;
    }

    private RelNode aggregateCorrelatorOutput(CorrelatorRel corRel, ProjectRel projRel, Set<Integer> isCount) {
        RelNode leftInputRel = corRel.getLeft();
        JoinRelType joinType = corRel.getJoinType();
        ArrayList<Pair<RexNode, String>> newProjects = new ArrayList<Pair<RexNode, String>>();
        List<RelDataTypeField> leftInputFields = leftInputRel.getRowType().getFieldList();
        for (int i = 0; i < leftInputFields.size(); ++i) {
            newProjects.add(RexInputRef.of2(i, leftInputFields));
        }
        boolean projectPulledAboveLeftCorrelator = joinType.generatesNullsOnRight();
        for (Pair<RexNode, String> pair : projRel.getNamedProjects()) {
            RexNode newProjExpr = this.removeCorrelationExpr((RexNode)pair.left, projectPulledAboveLeftCorrelator, isCount);
            newProjects.add(Pair.of(newProjExpr, pair.right));
        }
        return CalcRel.createProject((RelNode)corRel, newProjects, false);
    }

    private boolean checkCorVars(CorrelatorRel corRel, ProjectRel projRel, FilterRel filterRel, List<RexFieldAccess> correlatedJoinKeys) {
        if (filterRel != null) {
            assert (correlatedJoinKeys != null);
            HashSet corVarInFilter = new HashSet();
            corVarInFilter.addAll(this.mapRefRelToCorVar.get(filterRel));
            for (RexFieldAccess correlatedJoinKey : correlatedJoinKeys) {
                corVarInFilter.remove(this.mapFieldAccessToCorVar.get(correlatedJoinKey));
            }
            if (!corVarInFilter.isEmpty()) {
                return false;
            }
            corVarInFilter.addAll(this.mapRefRelToCorVar.get(filterRel));
            for (CorrelatorRel.Correlation corVar : corVarInFilter) {
                if (this.mapCorVarToCorRel.get(corVar) == corRel) continue;
                return false;
            }
        }
        if (projRel != null && this.mapRefRelToCorVar.containsKey(projRel)) {
            SortedSet<CorrelatorRel.Correlation> corVarInProj = this.mapRefRelToCorVar.get(projRel);
            for (CorrelatorRel.Correlation corVar : corVarInProj) {
                if (this.mapCorVarToCorRel.get(corVar) == corRel) continue;
                return false;
            }
        }
        return true;
    }

    private void removeCorVarFromTree(CorrelatorRel corRel) {
        HashSet<CorrelatorRel.Correlation> corVarSet = new HashSet<CorrelatorRel.Correlation>();
        corVarSet.addAll(this.mapCorVarToCorRel.keySet());
        for (CorrelatorRel.Correlation corVar : corVarSet) {
            if (this.mapCorVarToCorRel.get(corVar) != corRel) continue;
            this.mapCorVarToCorRel.remove(corVar);
        }
    }

    private RelNode createProjectWithAdditionalExprs(RelNode childRel, List<Pair<RexNode, String>> additionalExprs) {
        List<RelDataTypeField> fieldList = childRel.getRowType().getFieldList();
        ArrayList<Pair<RexNode, String>> projects = new ArrayList<Pair<RexNode, String>>();
        for (Ord<RelDataTypeField> field : Ord.zip(fieldList)) {
            projects.add(Pair.of(this.rexBuilder.makeInputRef(((RelDataTypeField)field.e).getType(), field.i), ((RelDataTypeField)field.e).getName()));
        }
        projects.addAll(additionalExprs);
        return CalcRel.createProject(childRel, projects, false);
    }

    private final class AdjustProjectForCountAggregateRule
    extends RelOptRule {
        final boolean flavor;

        public AdjustProjectForCountAggregateRule(boolean flavor) {
            super(flavor ? AdjustProjectForCountAggregateRule.operand(CorrelatorRel.class, AdjustProjectForCountAggregateRule.operand(RelNode.class, AdjustProjectForCountAggregateRule.any()), AdjustProjectForCountAggregateRule.operand(ProjectRel.class, AdjustProjectForCountAggregateRule.operand(AggregateRel.class, AdjustProjectForCountAggregateRule.any()), new RelOptRuleOperand[0])) : AdjustProjectForCountAggregateRule.operand(CorrelatorRel.class, AdjustProjectForCountAggregateRule.operand(RelNode.class, AdjustProjectForCountAggregateRule.any()), AdjustProjectForCountAggregateRule.operand(AggregateRel.class, AdjustProjectForCountAggregateRule.any())));
            this.flavor = flavor;
        }

        public void onMatch(RelOptRuleCall call) {
            AggregateRel aggRel;
            ProjectRel aggOutputProjRel;
            CorrelatorRel corRel = (CorrelatorRel)call.rel(0);
            Object leftInputRel = call.rel(1);
            if (this.flavor) {
                aggOutputProjRel = (ProjectRel)call.rel(2);
                aggRel = (AggregateRel)call.rel(3);
            } else {
                aggRel = (AggregateRel)call.rel(2);
                ArrayList<Pair<RexNode, String>> projects = new ArrayList<Pair<RexNode, String>>();
                List<RelDataTypeField> fields = aggRel.getRowType().getFieldList();
                for (int i = 0; i < fields.size(); ++i) {
                    projects.add(RexInputRef.of2(projects.size(), fields));
                }
                aggOutputProjRel = (ProjectRel)CalcRel.createProject((RelNode)aggRel, projects, false);
            }
            this.onMatch2(call, corRel, (RelNode)leftInputRel, aggOutputProjRel, aggRel);
        }

        private void onMatch2(RelOptRuleCall call, CorrelatorRel corRel, RelNode leftInputRel, ProjectRel aggOutputProjRel, AggregateRel aggRel) {
            RelOptCluster cluster = corRel.getCluster();
            if (RelDecorrelator.this.generatedCorRels.contains(corRel)) {
                return;
            }
            RelDecorrelator.this.currentRel = corRel;
            List<RexNode> aggOutputProjExprs = aggOutputProjRel.getProjects();
            if (aggOutputProjExprs.size() != 1) {
                return;
            }
            JoinRelType joinType = corRel.getJoinType();
            RexNode joinCond = corRel.getCondition();
            if (joinType != JoinRelType.LEFT || joinCond != RelDecorrelator.this.rexBuilder.makeLiteral(true)) {
                return;
            }
            if (!aggRel.getGroupSet().isEmpty()) {
                return;
            }
            List<AggregateCall> aggCalls = aggRel.getAggCallList();
            HashSet<Integer> isCount = new HashSet<Integer>();
            int i = -1;
            for (AggregateCall aggCall : aggCalls) {
                ++i;
                if (!(aggCall.getAggregation() instanceof SqlCountAggFunction)) continue;
                isCount.add(i);
            }
            CorrelatorRel newCorRel = new CorrelatorRel(cluster, leftInputRel, aggRel, corRel.getCorrelations(), corRel.getJoinType());
            RelDecorrelator.this.generatedCorRels.add(newCorRel);
            HashSet corVars = new HashSet();
            corVars.addAll(RelDecorrelator.this.mapCorVarToCorRel.keySet());
            for (CorrelatorRel.Correlation corVar : corVars) {
                if (RelDecorrelator.this.mapCorVarToCorRel.get(corVar) != corRel) continue;
                RelDecorrelator.this.mapCorVarToCorRel.put(corVar, newCorRel);
            }
            RelNode newOutputRel = RelDecorrelator.this.aggregateCorrelatorOutput(newCorRel, aggOutputProjRel, isCount);
            call.transformTo(newOutputRel);
        }
    }

    private final class RemoveCorrelationForScalarAggregateRule
    extends RelOptRule {
        public RemoveCorrelationForScalarAggregateRule() {
            super(RemoveCorrelationForScalarAggregateRule.operand(CorrelatorRel.class, RemoveCorrelationForScalarAggregateRule.operand(RelNode.class, RemoveCorrelationForScalarAggregateRule.any()), RemoveCorrelationForScalarAggregateRule.operand(ProjectRel.class, RemoveCorrelationForScalarAggregateRule.operand(AggregateRel.class, RemoveCorrelationForScalarAggregateRule.operand(ProjectRel.class, RemoveCorrelationForScalarAggregateRule.operand(RelNode.class, RemoveCorrelationForScalarAggregateRule.any()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), new RelOptRuleOperand[0])));
        }

        public void onMatch(RelOptRuleCall call) {
            CorrelatorRel corRel = (CorrelatorRel)call.rel(0);
            Object leftInputRel = call.rel(1);
            ProjectRel aggOutputProjRel = (ProjectRel)call.rel(2);
            AggregateRel aggRel = (AggregateRel)call.rel(3);
            ProjectRel aggInputProjRel = (ProjectRel)call.rel(4);
            Object rightInputRel = call.rel(5);
            RelOptCluster cluster = corRel.getCluster();
            RelDecorrelator.this.currentRel = corRel;
            List<RexNode> aggOutputProjExprs = aggOutputProjRel.getProjects();
            if (aggOutputProjExprs.size() != 1) {
                return;
            }
            JoinRelType joinType = corRel.getJoinType();
            RexNode joinCond = corRel.getCondition();
            if (joinType != JoinRelType.LEFT || joinCond != RelDecorrelator.this.rexBuilder.makeLiteral(true)) {
                return;
            }
            if (!aggRel.getGroupSet().isEmpty()) {
                return;
            }
            List<RexNode> aggInputProjExprs = aggInputProjRel.getProjects();
            List<AggregateCall> aggCalls = aggRel.getAggCallList();
            HashSet<Integer> isCountStar = new HashSet<Integer>();
            int k = -1;
            for (AggregateCall aggCall : aggCalls) {
                ++k;
                if (!(aggCall.getAggregation() instanceof SqlCountAggFunction) || aggCall.getArgList().size() != 0) continue;
                isCountStar.add(k);
            }
            if (rightInputRel instanceof FilterRel && RelDecorrelator.this.mapRefRelToCorVar.containsKey(rightInputRel)) {
                FilterRel filterRel = (FilterRel)rightInputRel;
                rightInputRel = filterRel.getChild();
                assert (rightInputRel instanceof HepRelVertex);
                if (RelOptUtil.getVariablesUsed(rightInputRel = ((HepRelVertex)rightInputRel).getCurrentRel()).size() > 0) {
                    return;
                }
                ArrayList<RexNode> rightJoinKeys = new ArrayList<RexNode>();
                ArrayList<RexNode> tmpCorrelatedJoinKeys = new ArrayList<RexNode>();
                RelOptUtil.splitCorrelatedFilterCondition(filterRel, rightJoinKeys, tmpCorrelatedJoinKeys, true);
                ArrayList<RexFieldAccess> correlatedJoinKeys = new ArrayList<RexFieldAccess>();
                ArrayList<RexInputRef> correlatedInputRefJoinKeys = new ArrayList<RexInputRef>();
                for (RexNode joinKey : tmpCorrelatedJoinKeys) {
                    assert (joinKey instanceof RexFieldAccess);
                    correlatedJoinKeys.add((RexFieldAccess)joinKey);
                    RexNode correlatedInputRef = RelDecorrelator.this.removeCorrelationExpr(joinKey, false);
                    assert (correlatedInputRef instanceof RexInputRef);
                    correlatedInputRefJoinKeys.add((RexInputRef)correlatedInputRef);
                }
                if (correlatedInputRefJoinKeys.isEmpty()) {
                    return;
                }
                if (!RelMdUtil.areColumnsDefinitelyUniqueWhenNullsFiltered(leftInputRel, correlatedInputRefJoinKeys)) {
                    SQL2REL_LOGGER.fine(((Object)correlatedJoinKeys).toString() + "are not unique keys for " + leftInputRel.toString());
                    return;
                }
                if (!RelDecorrelator.this.checkCorVars(corRel, aggInputProjRel, filterRel, correlatedJoinKeys)) {
                    return;
                }
                joinCond = RelDecorrelator.this.removeCorrelationExpr(filterRel.getCondition(), false);
            } else if (RelDecorrelator.this.mapRefRelToCorVar.containsKey(aggInputProjRel)) {
                if (RelOptUtil.getVariablesUsed(rightInputRel).size() > 0) {
                    return;
                }
                if (!RelDecorrelator.this.checkCorVars(corRel, aggInputProjRel, null, null)) {
                    return;
                }
                int nFields = leftInputRel.getRowType().getFieldCount();
                BitSet allCols = BitSets.range(nFields);
                if (!RelMdUtil.areColumnsDefinitelyUnique(leftInputRel, allCols)) {
                    SQL2REL_LOGGER.fine("There are no unique keys for " + leftInputRel);
                    return;
                }
            } else {
                return;
            }
            RelDataType leftInputFieldType = leftInputRel.getRowType();
            int leftInputFieldCount = leftInputFieldType.getFieldCount();
            int joinOutputProjExprCount = leftInputFieldCount + aggInputProjExprs.size() + 1;
            rightInputRel = RelDecorrelator.this.createProjectWithAdditionalExprs(rightInputRel, Collections.singletonList(Pair.of(RelDecorrelator.this.rexBuilder.makeLiteral(true), "nullIndicator")));
            JoinRel joinRel = new JoinRel(cluster, (RelNode)leftInputRel, (RelNode)rightInputRel, joinCond, joinType, (Set<String>)ImmutableSet.<String>of());
            int nullIndicatorPos = joinRel.getRowType().getFieldCount() - 1;
            RexInputRef nullIndicator = new RexInputRef(nullIndicatorPos, cluster.getTypeFactory().createTypeWithNullability(joinRel.getRowType().getFieldList().get(nullIndicatorPos).getType(), true));
            ArrayList<RexNode> joinOutputProjExprs = new ArrayList<RexNode>();
            for (int i = 0; i < leftInputFieldCount; ++i) {
                joinOutputProjExprs.add(RelDecorrelator.this.rexBuilder.makeInputRef(leftInputFieldType.getFieldList().get(i).getType(), i));
            }
            for (RexNode aggInputProjExpr : aggInputProjExprs) {
                joinOutputProjExprs.add(RelDecorrelator.this.removeCorrelationExpr(aggInputProjExpr, joinType.generatesNullsOnRight(), nullIndicator));
            }
            joinOutputProjExprs.add(RelDecorrelator.this.rexBuilder.makeInputRef(joinRel, nullIndicatorPos));
            RelNode joinOutputProjRel = CalcRel.createProject((RelNode)joinRel, joinOutputProjExprs, null);
            nullIndicatorPos = joinOutputProjExprCount - 1;
            int groupCount = leftInputFieldCount;
            ArrayList<AggregateCall> newAggCalls = new ArrayList<AggregateCall>();
            k = -1;
            for (AggregateCall aggCall : aggCalls) {
                List<Integer> newAggArgs;
                List<Integer> aggArgs = aggCall.getArgList();
                if (isCountStar.contains(++k)) {
                    newAggArgs = Collections.singletonList(nullIndicatorPos);
                } else {
                    newAggArgs = new ArrayList<Integer>();
                    for (Integer aggArg : aggArgs) {
                        newAggArgs.add(aggArg + groupCount);
                    }
                }
                newAggCalls.add(aggCall.adaptTo(joinOutputProjRel, newAggArgs, aggRel.getGroupCount(), groupCount));
            }
            BitSet groupSet = BitSets.range(groupCount);
            AggregateRel newAggRel = new AggregateRel(cluster, joinOutputProjRel, groupSet, newAggCalls);
            ArrayList<RexNode> newAggOutputProjExprList = new ArrayList<RexNode>();
            for (int i : BitSets.toIter(groupSet)) {
                newAggOutputProjExprList.add(RelDecorrelator.this.rexBuilder.makeInputRef(newAggRel, i));
            }
            RexNode newAggOutputProjExpr = RelDecorrelator.this.removeCorrelationExpr(aggOutputProjExprs.get(0), false);
            newAggOutputProjExprList.add(RelDecorrelator.this.rexBuilder.makeCast(cluster.getTypeFactory().createTypeWithNullability(newAggOutputProjExpr.getType(), true), newAggOutputProjExpr));
            RelNode newAggOutputProjRel = CalcRel.createProject((RelNode)newAggRel, newAggOutputProjExprList, null);
            call.transformTo(newAggOutputProjRel);
            RelDecorrelator.this.removeCorVarFromTree(corRel);
        }
    }

    private final class RemoveCorrelationForScalarProjectRule
    extends RelOptRule {
        public RemoveCorrelationForScalarProjectRule() {
            super(RemoveCorrelationForScalarProjectRule.operand(CorrelatorRel.class, RemoveCorrelationForScalarProjectRule.operand(RelNode.class, RemoveCorrelationForScalarProjectRule.any()), RemoveCorrelationForScalarProjectRule.operand(AggregateRel.class, RemoveCorrelationForScalarProjectRule.operand(ProjectRel.class, RemoveCorrelationForScalarProjectRule.operand(RelNode.class, RemoveCorrelationForScalarProjectRule.any()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0])));
        }

        public void onMatch(RelOptRuleCall call) {
            int nullIndicatorPos;
            CorrelatorRel corRel = (CorrelatorRel)call.rel(0);
            Object leftInputRel = call.rel(1);
            AggregateRel aggRel = (AggregateRel)call.rel(2);
            ProjectRel projRel = (ProjectRel)call.rel(3);
            Object rightInputRel = call.rel(4);
            RelOptCluster cluster = corRel.getCluster();
            RelDecorrelator.this.currentRel = corRel;
            JoinRelType joinType = corRel.getJoinType();
            RexNode joinCond = corRel.getCondition();
            if (joinType != JoinRelType.LEFT || joinCond != RelDecorrelator.this.rexBuilder.makeLiteral(true)) {
                return;
            }
            if (!aggRel.getGroupSet().isEmpty() || aggRel.getAggCallList().size() != 1 || !(aggRel.getAggCallList().get(0).getAggregation() instanceof SqlSingleValueAggFunction)) {
                return;
            }
            if (projRel.getProjects().size() != 1) {
                return;
            }
            if (rightInputRel instanceof FilterRel && RelDecorrelator.this.mapRefRelToCorVar.containsKey(rightInputRel)) {
                FilterRel filterRel = (FilterRel)rightInputRel;
                rightInputRel = filterRel.getChild();
                assert (rightInputRel instanceof HepRelVertex);
                if (RelOptUtil.getVariablesUsed(rightInputRel = ((HepRelVertex)rightInputRel).getCurrentRel()).size() > 0) {
                    return;
                }
                ArrayList<RexNode> tmpRightJoinKeys = new ArrayList<RexNode>();
                ArrayList<RexNode> correlatedJoinKeys = new ArrayList<RexNode>();
                RelOptUtil.splitCorrelatedFilterCondition(filterRel, tmpRightJoinKeys, correlatedJoinKeys, false);
                ArrayList<RexInputRef> rightJoinKeys = new ArrayList<RexInputRef>();
                for (int i = 0; i < tmpRightJoinKeys.size(); ++i) {
                    assert (tmpRightJoinKeys.get(i) instanceof RexInputRef);
                    rightJoinKeys.add((RexInputRef)tmpRightJoinKeys.get(i));
                }
                if (rightJoinKeys.isEmpty()) {
                    return;
                }
                if (!RelMdUtil.areColumnsDefinitelyUniqueWhenNullsFiltered((RelNode)rightInputRel, rightJoinKeys)) {
                    SQL2REL_LOGGER.fine(((Object)rightJoinKeys).toString() + "are not unique keys for " + rightInputRel.toString());
                    return;
                }
                RexUtil.FieldAccessFinder visitor = new RexUtil.FieldAccessFinder();
                RexUtil.apply(visitor, correlatedJoinKeys, null);
                List<RexFieldAccess> correlatedKeyList = visitor.getFieldAccessList();
                if (!RelDecorrelator.this.checkCorVars(corRel, projRel, filterRel, correlatedKeyList)) {
                    return;
                }
                joinCond = RelDecorrelator.this.removeCorrelationExpr(filterRel.getCondition(), false);
                nullIndicatorPos = leftInputRel.getRowType().getFieldCount() + ((RexInputRef)rightJoinKeys.get(0)).getIndex();
            } else if (RelDecorrelator.this.mapRefRelToCorVar.containsKey(projRel)) {
                if (RelOptUtil.getVariablesUsed(rightInputRel).size() > 0) {
                    return;
                }
                if (!RelDecorrelator.this.checkCorVars(corRel, projRel, null, null)) {
                    return;
                }
                rightInputRel = RelDecorrelator.this.createProjectWithAdditionalExprs(rightInputRel, Collections.singletonList(Pair.of(RelDecorrelator.this.rexBuilder.makeLiteral(true), "nullIndicator")));
                rightInputRel = RelOptUtil.createSingleValueAggRel(cluster, rightInputRel);
                nullIndicatorPos = leftInputRel.getRowType().getFieldCount() + rightInputRel.getRowType().getFieldCount() - 1;
            } else {
                return;
            }
            JoinRel joinRel = new JoinRel(corRel.getCluster(), (RelNode)leftInputRel, (RelNode)rightInputRel, joinCond, joinType, (Set<String>)ImmutableSet.<String>of());
            RelNode newProjRel = RelDecorrelator.this.projectJoinOutputWithNullability(joinRel, projRel, nullIndicatorPos);
            call.transformTo(newProjRel);
            RelDecorrelator.this.removeCorVarFromTree(corRel);
        }
    }

    private final class RemoveSingleAggregateRule
    extends RelOptRule {
        public RemoveSingleAggregateRule() {
            super(RemoveSingleAggregateRule.operand(AggregateRel.class, RemoveSingleAggregateRule.operand(ProjectRel.class, RemoveSingleAggregateRule.operand(AggregateRel.class, RemoveSingleAggregateRule.any()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]));
        }

        public void onMatch(RelOptRuleCall call) {
            AggregateRel singleAggRel = (AggregateRel)call.rel(0);
            ProjectRel projRel = (ProjectRel)call.rel(1);
            AggregateRel aggRel = (AggregateRel)call.rel(2);
            if (!singleAggRel.getGroupSet().isEmpty() || singleAggRel.getAggCallList().size() != 1 || !(singleAggRel.getAggCallList().get(0).getAggregation() instanceof SqlSingleValueAggFunction)) {
                return;
            }
            List<RexNode> projExprs = projRel.getProjects();
            if (projExprs.size() != 1) {
                return;
            }
            if (!aggRel.getGroupSet().isEmpty()) {
                return;
            }
            RelNode newProjRel = CalcRel.createProject((RelNode)aggRel, Collections.singletonList(RelDecorrelator.this.rexBuilder.makeCast(projRel.getCluster().getTypeFactory().createTypeWithNullability(projExprs.get(0).getType(), true), projExprs.get(0))), null);
            call.transformTo(newProjRel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoveCorrelationRexShuttle
    extends RexShuttle {
        RexBuilder rexBuilder;
        RelDataTypeFactory typeFactory;
        boolean projectPulledAboveLeftCorrelator;
        RexInputRef nullIndicator;
        Set<Integer> isCount;

        public RemoveCorrelationRexShuttle(RexBuilder rexBuilder, boolean projectPulledAboveLeftCorrelator) {
            this(rexBuilder, projectPulledAboveLeftCorrelator, null, null);
        }

        public RemoveCorrelationRexShuttle(RexBuilder rexBuilder, boolean projectPulledAboveLeftCorrelator, RexInputRef nullIndicator) {
            this(rexBuilder, projectPulledAboveLeftCorrelator, nullIndicator, null);
        }

        public RemoveCorrelationRexShuttle(RexBuilder rexBuilder, boolean projectPulledAboveLeftCorrelator, Set<Integer> isCount) {
            this(rexBuilder, projectPulledAboveLeftCorrelator, null, isCount);
        }

        public RemoveCorrelationRexShuttle(RexBuilder rexBuilder, boolean projectPulledAboveLeftCorrelator, RexInputRef nullIndicator, Set<Integer> isCount) {
            this.projectPulledAboveLeftCorrelator = projectPulledAboveLeftCorrelator;
            this.nullIndicator = nullIndicator;
            this.isCount = isCount;
            this.rexBuilder = rexBuilder;
            this.typeFactory = rexBuilder.getTypeFactory();
        }

        private RexNode createCaseExpression(RexInputRef nullInputRef, RexLiteral lit, RexNode rexNode) {
            RexNode[] caseOperands = new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexInputRef(nullInputRef.getIndex(), this.typeFactory.createTypeWithNullability(nullInputRef.getType(), true))), this.rexBuilder.makeCast(this.typeFactory.createTypeWithNullability(rexNode.getType(), true), lit), this.rexBuilder.makeCast(this.typeFactory.createTypeWithNullability(rexNode.getType(), true), rexNode)};
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, caseOperands);
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            if (RelDecorrelator.this.mapFieldAccessToCorVar.containsKey(fieldAccess)) {
                CorrelatorRel.Correlation corVar = (CorrelatorRel.Correlation)RelDecorrelator.this.mapFieldAccessToCorVar.get(fieldAccess);
                RexNode newRexNode = new RexInputRef(corVar.getOffset(), fieldAccess.getType());
                if (this.projectPulledAboveLeftCorrelator && this.nullIndicator != null) {
                    newRexNode = this.createCaseExpression(this.nullIndicator, this.rexBuilder.constantNull(), newRexNode);
                }
                return newRexNode;
            }
            return fieldAccess;
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            if (RelDecorrelator.this.currentRel != null && RelDecorrelator.this.currentRel instanceof CorrelatorRel) {
                int leftInputFieldCount = ((CorrelatorRel)RelDecorrelator.this.currentRel).getLeft().getRowType().getFieldCount();
                RelDataType newType = inputRef.getType();
                if (this.projectPulledAboveLeftCorrelator) {
                    newType = this.typeFactory.createTypeWithNullability(newType, true);
                }
                int pos = inputRef.getIndex();
                RexInputRef newInputRef = new RexInputRef(leftInputFieldCount + pos, newType);
                if (this.isCount != null && this.isCount.contains(pos)) {
                    return this.createCaseExpression(newInputRef, this.rexBuilder.makeExactLiteral(BigDecimal.ZERO), newInputRef);
                }
                return newInputRef;
            }
            return inputRef;
        }

        @Override
        public RexNode visitLiteral(RexLiteral literal) {
            if (!RexUtil.isNull(literal) && this.projectPulledAboveLeftCorrelator && this.nullIndicator != null) {
                return this.createCaseExpression(this.nullIndicator, this.rexBuilder.constantNull(), literal);
            }
            return literal;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            RexNode newCall;
            boolean[] update = new boolean[]{false};
            List<RexNode> clonedOperands = this.visitList(call.operands, update);
            if (update[0]) {
                SqlFunction function;
                SqlOperator operator = call.getOperator();
                boolean isSpecialCast = false;
                if (operator instanceof SqlFunction && (function = (SqlFunction)operator).getKind() == SqlKind.CAST && call.operands.size() < 2) {
                    isSpecialCast = true;
                }
                newCall = !isSpecialCast ? this.rexBuilder.makeCall(operator, clonedOperands) : this.rexBuilder.makeCall(call.getType(), operator, clonedOperands);
            } else {
                newCall = call;
            }
            if (this.projectPulledAboveLeftCorrelator && this.nullIndicator != null) {
                return this.createCaseExpression(this.nullIndicator, this.rexBuilder.constantNull(), newCall);
            }
            return newCall;
        }
    }

    private class DecorrelateRelVisitor
    extends RelVisitor {
        private final ReflectiveVisitDispatcher<RelDecorrelator, RelNode> dispatcher = ReflectUtil.createDispatcher(RelDecorrelator.class, RelNode.class);

        private DecorrelateRelVisitor() {
        }

        public void visit(RelNode p, int ordinal, RelNode parent) {
            super.visit(p, ordinal, parent);
            RelDecorrelator.this.currentRel = p;
            String visitMethodName = "decorrelateRel";
            boolean found = this.dispatcher.invokeVisitor(RelDecorrelator.this, RelDecorrelator.this.currentRel, "decorrelateRel");
            RelDecorrelator.this.currentRel = null;
            if (!found) {
                RelDecorrelator.this.decorrelateRelGeneric(p);
            }
        }
    }
}

