/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.validate.AbstractNamespace;
import org.eigenbase.sql.validate.SqlValidatorImpl;
import org.eigenbase.sql.validate.SqlValidatorScope;

class UnnestNamespace
extends AbstractNamespace {
    private final SqlCall unnest;
    private final SqlValidatorScope scope;

    UnnestNamespace(SqlValidatorImpl validator, SqlCall unnest, SqlValidatorScope scope, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        assert (scope != null);
        assert (unnest.getOperator() == SqlStdOperatorTable.UNNEST);
        this.unnest = unnest;
        this.scope = scope;
    }

    protected RelDataType validateImpl() {
        this.validator.validateCall(this.unnest, this.scope);
        RelDataType type = this.unnest.getOperator().validateOperands(this.validator, this.scope, this.unnest);
        if (type.isStruct()) {
            return type;
        }
        return this.validator.getTypeFactory().builder().add(this.validator.deriveAlias(this.unnest, 0), type).build();
    }

    public SqlNode getNode() {
        return this.unnest;
    }
}

