/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.hydromatic.optiq.prepare.Prepare;
import org.eigenbase.relopt.RelOptSchemaWithSampling;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlDataTypeSpec;
import org.eigenbase.sql.SqlDynamicParam;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlIntervalQualifier;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.sql.util.SqlShuttle;
import org.eigenbase.sql.validate.DelegatingScope;
import org.eigenbase.sql.validate.SelectScope;
import org.eigenbase.sql.validate.SqlScopedShuttle;
import org.eigenbase.sql.validate.SqlValidatorNamespace;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.sql.validate.TableNamespace;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlValidatorUtil {
    public static final Suggester EXPR_SUGGESTER = new Suggester(){

        public String apply(String original, int attempt, int size) {
            return Util.first(original, "EXPR$") + attempt;
        }
    };
    public static final Suggester F_SUGGESTER = new Suggester(){

        public String apply(String original, int attempt, int size) {
            return Util.first(original, "$f") + Math.max(size, attempt);
        }
    };

    private SqlValidatorUtil() {
    }

    public static RelOptTable getRelOptTable(SqlValidatorNamespace namespace, Prepare.CatalogReader catalogReader, String datasetName, boolean[] usedDataset) {
        if (namespace.isWrapperFor(TableNamespace.class)) {
            TableNamespace tableNamespace = namespace.unwrap(TableNamespace.class);
            List<String> names = tableNamespace.getTable().getQualifiedName();
            if (datasetName != null && catalogReader instanceof RelOptSchemaWithSampling) {
                return ((RelOptSchemaWithSampling)((Object)catalogReader)).getTableForMember(names, datasetName, usedDataset);
            }
            return catalogReader.getTableForMember(names);
        }
        return null;
    }

    public static RelDataTypeField lookupField(boolean caseSensitive, RelDataType rowType, String columnName) {
        return rowType.getField(columnName, caseSensitive);
    }

    public static void checkCharsetAndCollateConsistentIfCharType(RelDataType type) {
        if (SqlTypeUtil.inCharFamily(type)) {
            Charset strCharset = type.getCharset();
            Charset colCharset = type.getCollation().getCharset();
            assert (null != strCharset);
            assert (null != colCharset);
            if (!strCharset.equals(colCharset)) {
                // empty if block
            }
        }
    }

    public static SqlNode addAlias(SqlNode expr, String alias) {
        SqlParserPos pos = expr.getParserPosition();
        SqlIdentifier id = new SqlIdentifier(alias, pos);
        return SqlStdOperatorTable.AS.createCall(pos, expr, id);
    }

    public static String getAlias(SqlNode node, int ordinal) {
        switch (node.getKind()) {
            case AS: {
                return ((SqlNode)((SqlCall)node).operand(1)).toString();
            }
            case OVER: {
                return SqlValidatorUtil.getAlias(((SqlCall)node).operand(0), ordinal);
            }
            case IDENTIFIER: {
                return Util.last(((SqlIdentifier)node).names);
            }
        }
        if (ordinal < 0) {
            return null;
        }
        return SqlUtil.deriveAliasFromOrdinal(ordinal);
    }

    public static String uniquify(String name, Set<String> nameList, Suggester suggester) {
        if (name != null && nameList.add(name)) {
            return name;
        }
        String originalName = name;
        int j = 0;
        while (!nameList.add(name = suggester.apply(originalName, j, nameList.size()))) {
            ++j;
        }
        return name;
    }

    public static List<String> uniquify(List<String> nameList) {
        return SqlValidatorUtil.uniquify(nameList, EXPR_SUGGESTER);
    }

    public static List<String> uniquify(List<String> nameList, Suggester suggester) {
        LinkedHashSet<String> used = new LinkedHashSet<String>();
        int changeCount = 0;
        for (String name : nameList) {
            String uniqueName = SqlValidatorUtil.uniquify(name, used, suggester);
            if (uniqueName.equals(name)) continue;
            ++changeCount;
        }
        return changeCount == 0 ? nameList : new ArrayList(used);
    }

    public static SqlValidatorNamespace lookup(SqlValidatorScope scope, List<String> names) {
        assert (names.size() > 0);
        SqlValidatorNamespace namespace = null;
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            namespace = i == 0 ? scope.resolve(name, null, null) : namespace.lookupChild(name);
        }
        assert (namespace != null);
        return namespace;
    }

    public static SelectScope getEnclosingSelectScope(SqlValidatorScope scope) {
        while (scope instanceof DelegatingScope) {
            if (scope instanceof SelectScope) {
                return (SelectScope)scope;
            }
            scope = ((DelegatingScope)scope).getParent();
        }
        return null;
    }

    public static List<String> deriveNaturalJoinColumnList(RelDataType leftRowType, RelDataType rightRowType) {
        ArrayList<String> naturalColumnNames = new ArrayList<String>();
        List<String> leftNames = leftRowType.getFieldNames();
        List<String> rightNames = rightRowType.getFieldNames();
        for (String name : leftNames) {
            if (Collections.frequency(leftNames, name) != 1 || Collections.frequency(rightNames, name) != 1) continue;
            naturalColumnNames.add(name);
        }
        return naturalColumnNames;
    }

    static interface Suggester {
        public String apply(String var1, int var2, int var3);
    }

    public static class DeepCopier
    extends SqlScopedShuttle {
        DeepCopier(SqlValidatorScope scope) {
            super(scope);
        }

        public SqlNode visit(SqlNodeList list) {
            SqlNodeList copy = new SqlNodeList(list.getParserPosition());
            for (SqlNode node : list) {
                copy.add(node.accept(this));
            }
            return copy;
        }

        protected SqlNode visitScoped(SqlCall call) {
            SqlShuttle.CallCopyingArgHandler argHandler = new SqlShuttle.CallCopyingArgHandler(call, true);
            call.getOperator().acceptCall(this, call, false, argHandler);
            return (SqlNode)argHandler.result();
        }

        public SqlNode visit(SqlLiteral literal) {
            return (SqlNode)literal.clone();
        }

        public SqlNode visit(SqlIdentifier id) {
            return this.getScope().fullyQualify(id);
        }

        public SqlNode visit(SqlDataTypeSpec type) {
            return (SqlNode)type.clone();
        }

        public SqlNode visit(SqlDynamicParam param) {
            return (SqlNode)param.clone();
        }

        public SqlNode visit(SqlIntervalQualifier intervalQualifier) {
            return (SqlNode)intervalQualifier.clone();
        }
    }
}

