/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.hydromatic.linq4j.expressions.BlockBuilder;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.FunctionExpression;
import net.hydromatic.optiq.Function;
import net.hydromatic.optiq.FunctionParameter;
import net.hydromatic.optiq.TableMacro;
import net.hydromatic.optiq.TranslatableTable;
import net.hydromatic.optiq.rules.java.RexToLixTranslator;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeFactoryImpl;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.type.SqlOperandTypeInference;
import org.eigenbase.sql.type.SqlReturnTypeInference;
import org.eigenbase.util.NlsString;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlUserDefinedTableMacro
extends SqlFunction {
    private final TableMacro tableMacro;

    public SqlUserDefinedTableMacro(SqlIdentifier opName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, TableMacro tableMacro) {
        super(Util.last(opName.names), opName, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeInference, operandTypeChecker, null, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        this.tableMacro = tableMacro;
    }

    public TranslatableTable getTable(RelDataTypeFactory typeFactory, List<SqlNode> operandList) {
        List<Object> arguments = SqlUserDefinedTableMacro.convertArguments(typeFactory, operandList, this.tableMacro, this.getNameAsId(), true);
        return this.tableMacro.apply(arguments);
    }

    public static List<Object> convertArguments(RelDataTypeFactory typeFactory, List<SqlNode> operandList, Function function, SqlIdentifier opName, boolean failOnNonLiteral) {
        ArrayList<Object> arguments = new ArrayList<Object>(operandList.size());
        for (Pair<FunctionParameter, SqlNode> pair : Pair.zip(function.getParameters(), operandList)) {
            if (SqlUtil.isNullLiteral((SqlNode)pair.right, true)) {
                arguments.add(null);
                continue;
            }
            if (SqlUtil.isLiteral((SqlNode)pair.right)) {
                Object o = ((SqlLiteral)pair.right).getValue();
                Object o2 = SqlUserDefinedTableMacro.coerce(o, ((FunctionParameter)pair.left).getType(typeFactory));
                arguments.add(o2);
                continue;
            }
            arguments.add(null);
            if (!failOnNonLiteral) continue;
            throw new IllegalArgumentException("All arguments of call to macro " + opName + " should be " + "literal. Actual argument #" + ((FunctionParameter)pair.left).getOrdinal() + " (" + ((FunctionParameter)pair.left).getName() + ") is not literal: " + pair.right);
        }
        return arguments;
    }

    private static Object coerce(Object o, RelDataType type) {
        if (!(type instanceof RelDataTypeFactoryImpl.JavaType)) {
            return null;
        }
        RelDataTypeFactoryImpl.JavaType javaType = (RelDataTypeFactoryImpl.JavaType)type;
        Class clazz = javaType.getJavaClass();
        if (clazz.isAssignableFrom(o.getClass())) {
            return o;
        }
        if (clazz == String.class && o instanceof NlsString) {
            return ((NlsString)o).getValue();
        }
        BlockBuilder bb = new BlockBuilder();
        Expression expr = RexToLixTranslator.convert(Expressions.constant(o), clazz);
        bb.add(Expressions.return_(null, expr));
        FunctionExpression convert = Expressions.lambda(bb.toBlock(), Collections.emptyList());
        return convert.compile().dynamicInvoke(new Object[0]);
    }
}

