/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.validate.SqlMoniker;
import org.eigenbase.sql.validate.SqlMonikerType;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlMonikerImpl
implements SqlMoniker {
    private final ImmutableList<String> names;
    private final SqlMonikerType type;

    public SqlMonikerImpl(List<String> names, SqlMonikerType type) {
        assert (names != null);
        assert (type != null);
        for (String name : names) {
            assert (name != null);
        }
        this.names = ImmutableList.copyOf(names);
        this.type = type;
    }

    public SqlMonikerImpl(String name, SqlMonikerType type) {
        this(ImmutableList.of(name), type);
    }

    @Override
    public SqlIdentifier toIdentifier() {
        return new SqlIdentifier(this.names, SqlParserPos.ZERO);
    }

    public String toString() {
        return Util.sepList(this.names, ".");
    }
}

