/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import com.google.common.collect.ImmutableList;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.type.SqlReturnTypeInference;
import org.eigenbase.sql.type.SqlTypeTransform;

public class SqlTypeTransformCascade
implements SqlReturnTypeInference {
    private final SqlReturnTypeInference rule;
    private final ImmutableList<SqlTypeTransform> transforms;

    public SqlTypeTransformCascade(SqlReturnTypeInference rule, SqlTypeTransform ... transforms) {
        assert (rule != null);
        assert (transforms.length > 0);
        this.rule = rule;
        this.transforms = ImmutableList.copyOf(transforms);
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType ret = this.rule.inferReturnType(opBinding);
        if (ret == null) {
            return null;
        }
        for (SqlTypeTransform transform : this.transforms) {
            ret = transform.transformType(opBinding, ret);
        }
        return ret;
    }
}

