/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypePrecedenceList;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.ImmutableNullableList;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTypeExplicitPrecedenceList
implements RelDataTypePrecedenceList {
    private static final List<SqlTypeName> NUMERIC_TYPES = ImmutableNullableList.of(SqlTypeName.TINYINT, null, SqlTypeName.SMALLINT, null, SqlTypeName.INTEGER, null, SqlTypeName.BIGINT, null, new SqlTypeName[]{SqlTypeName.DECIMAL, null, SqlTypeName.REAL, null, SqlTypeName.FLOAT, SqlTypeName.DOUBLE});
    private static final List<SqlTypeName> COMPACT_NUMERIC_TYPES = ImmutableList.copyOf(Iterables.filter(NUMERIC_TYPES, Predicates.notNull()));
    private static final Map<SqlTypeName, SqlTypeExplicitPrecedenceList> TYPE_NAME_TO_PRECEDENCE_LIST = ImmutableMap.builder().put(SqlTypeName.BOOLEAN, SqlTypeExplicitPrecedenceList.list(SqlTypeName.BOOLEAN)).put(SqlTypeName.TINYINT, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.TINYINT)).put(SqlTypeName.INTEGER, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.INTEGER)).put(SqlTypeName.BIGINT, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.BIGINT)).put(SqlTypeName.DECIMAL, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.DECIMAL)).put(SqlTypeName.REAL, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.REAL)).put(SqlTypeName.FLOAT, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.FLOAT)).put(SqlTypeName.DOUBLE, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.DOUBLE)).put(SqlTypeName.CHAR, SqlTypeExplicitPrecedenceList.list(SqlTypeName.CHAR, SqlTypeName.VARCHAR)).put(SqlTypeName.VARCHAR, SqlTypeExplicitPrecedenceList.list(SqlTypeName.VARCHAR)).put(SqlTypeName.BINARY, SqlTypeExplicitPrecedenceList.list(SqlTypeName.BINARY, SqlTypeName.VARBINARY)).put(SqlTypeName.VARBINARY, SqlTypeExplicitPrecedenceList.list(SqlTypeName.VARBINARY)).put(SqlTypeName.DATE, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DATE)).put(SqlTypeName.TIME, SqlTypeExplicitPrecedenceList.list(SqlTypeName.TIME)).put(SqlTypeName.TIMESTAMP, SqlTypeExplicitPrecedenceList.list(SqlTypeName.TIMESTAMP)).put(SqlTypeName.INTERVAL_YEAR_MONTH, SqlTypeExplicitPrecedenceList.list(SqlTypeName.INTERVAL_YEAR_MONTH)).put(SqlTypeName.INTERVAL_DAY_TIME, SqlTypeExplicitPrecedenceList.list(SqlTypeName.INTERVAL_DAY_TIME)).build();
    private final List<SqlTypeName> typeNames = new ArrayList<SqlTypeName>();

    public SqlTypeExplicitPrecedenceList(List<SqlTypeName> typeNames) {
        this.typeNames.addAll(typeNames);
    }

    private static SqlTypeExplicitPrecedenceList list(SqlTypeName ... array) {
        return new SqlTypeExplicitPrecedenceList(ImmutableList.copyOf(array));
    }

    private static SqlTypeExplicitPrecedenceList numeric(SqlTypeName typeName) {
        int i = SqlTypeExplicitPrecedenceList.getListPosition(typeName, COMPACT_NUMERIC_TYPES);
        return new SqlTypeExplicitPrecedenceList(Util.skip(COMPACT_NUMERIC_TYPES, i));
    }

    @Override
    public boolean containsType(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        return typeName != null && this.typeNames.contains((Object)typeName);
    }

    @Override
    public int compareTypePrecedence(RelDataType type1, RelDataType type2) {
        assert (this.containsType(type1));
        assert (this.containsType(type2));
        int p1 = SqlTypeExplicitPrecedenceList.getListPosition(type1.getSqlTypeName(), this.typeNames);
        int p2 = SqlTypeExplicitPrecedenceList.getListPosition(type2.getSqlTypeName(), this.typeNames);
        return p2 - p1;
    }

    private static int getListPosition(SqlTypeName type, List<SqlTypeName> list) {
        int i = list.indexOf((Object)type);
        assert (i != -1);
        for (int j = i - 1; j >= 0; --j) {
            if (list.get(j) != null) continue;
            return j;
        }
        return i;
    }

    static RelDataTypePrecedenceList getListForType(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return null;
        }
        return TYPE_NAME_TO_PRECEDENCE_LIST.get((Object)typeName);
    }
}

