/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eigenbase.sql.type.SqlTypeName;

public class JavaToSqlTypeConversionRules {
    private static final JavaToSqlTypeConversionRules INSTANCE = new JavaToSqlTypeConversionRules();
    private final Map<Class<?>, SqlTypeName> rules = ImmutableMap.builder().put(Integer.class, SqlTypeName.INTEGER).put(Integer.TYPE, SqlTypeName.INTEGER).put(Long.class, SqlTypeName.BIGINT).put(Long.TYPE, SqlTypeName.BIGINT).put(Short.class, SqlTypeName.SMALLINT).put(Short.TYPE, SqlTypeName.SMALLINT).put(Byte.TYPE, SqlTypeName.TINYINT).put(Byte.class, SqlTypeName.TINYINT).put(Float.class, SqlTypeName.REAL).put(Float.TYPE, SqlTypeName.REAL).put(Double.class, SqlTypeName.DOUBLE).put(Double.TYPE, SqlTypeName.DOUBLE).put(Boolean.TYPE, SqlTypeName.BOOLEAN).put(Boolean.class, SqlTypeName.BOOLEAN).put(byte[].class, SqlTypeName.VARBINARY).put(String.class, SqlTypeName.VARCHAR).put(char[].class, SqlTypeName.VARCHAR).put(Character.class, SqlTypeName.CHAR).put(Character.TYPE, SqlTypeName.CHAR).put(Date.class, SqlTypeName.TIMESTAMP).put(java.sql.Date.class, SqlTypeName.DATE).put(Timestamp.class, SqlTypeName.TIMESTAMP).put(Time.class, SqlTypeName.TIME).put(BigDecimal.class, SqlTypeName.DECIMAL).put(ResultSet.class, SqlTypeName.CURSOR).put(ColumnList.class, SqlTypeName.COLUMN_LIST).build();

    public static JavaToSqlTypeConversionRules instance() {
        return INSTANCE;
    }

    public SqlTypeName lookup(Class javaClass) {
        return this.rules.get(javaClass);
    }

    private static interface ColumnList
    extends List {
    }
}

