/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.type.ExplicitOperandTypeInference;
import org.eigenbase.sql.type.SqlOperandTypeInference;
import org.eigenbase.sql.type.SqlTypeName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InferTypes {
    public static final SqlOperandTypeInference FIRST_KNOWN = new SqlOperandTypeInference(){

        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
            RelDataType unknownType;
            RelDataType knownType = unknownType = callBinding.getValidator().getUnknownType();
            for (SqlNode operand : callBinding.getCall().getOperandList()) {
                knownType = callBinding.getValidator().deriveType(callBinding.getScope(), operand);
                if (knownType.equals(unknownType)) continue;
                break;
            }
            for (int i = 0; i < operandTypes.length; ++i) {
                operandTypes[i] = knownType;
            }
        }
    };
    public static final SqlOperandTypeInference RETURN_TYPE = new SqlOperandTypeInference(){

        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
            for (int i = 0; i < operandTypes.length; ++i) {
                operandTypes[i] = returnType.isStruct() ? returnType.getFieldList().get(i).getType() : returnType;
            }
        }
    };
    public static final SqlOperandTypeInference BOOLEAN = new SqlOperandTypeInference(){

        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            for (int i = 0; i < operandTypes.length; ++i) {
                operandTypes[i] = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
            }
        }
    };
    public static final SqlOperandTypeInference VARCHAR_1024 = new SqlOperandTypeInference(){

        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            for (int i = 0; i < operandTypes.length; ++i) {
                operandTypes[i] = typeFactory.createSqlType(SqlTypeName.VARCHAR, 1024);
            }
        }
    };

    public static SqlOperandTypeInference explicit(List<RelDataType> types) {
        return new ExplicitOperandTypeInference(ImmutableList.copyOf(types));
    }
}

