/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.hydromatic.linq4j.Ord;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperandCountRange;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.type.SqlOperandCountRanges;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignableOperandTypeChecker
implements SqlOperandTypeChecker {
    private final List<RelDataType> paramTypes;

    public AssignableOperandTypeChecker(List<RelDataType> paramTypes) {
        this.paramTypes = ImmutableList.copyOf(paramTypes);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(this.paramTypes.size());
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        List<SqlNode> operands = callBinding.getCall().getOperandList();
        for (Pair<RelDataType, SqlNode> pair : Pair.zip(this.paramTypes, operands)) {
            RelDataType argType = callBinding.getValidator().deriveType(callBinding.getScope(), (SqlNode)pair.right);
            if (SqlTypeUtil.canAssignFrom((RelDataType)pair.left, argType)) continue;
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        return true;
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        StringBuilder sb = new StringBuilder();
        sb.append(opName);
        sb.append("(");
        for (Ord<RelDataType> paramType : Ord.zip(this.paramTypes)) {
            if (paramType.i > 0) {
                sb.append(", ");
            }
            sb.append("<");
            sb.append(((RelDataType)paramType.e).getFamily());
            sb.append(">");
        }
        sb.append(")");
        return sb.toString();
    }
}

