/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.fun;

import java.util.List;
import net.hydromatic.linq4j.Ord;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlCharStringLiteral;
import org.eigenbase.sql.SqlCollation;
import org.eigenbase.sql.SqlInternalOperator;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.InferTypes;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.BitString;
import org.eigenbase.util.NlsString;
import org.eigenbase.util.Static;
import org.eigenbase.util.Util;

public class SqlLiteralChainOperator
extends SqlInternalOperator {
    SqlLiteralChainOperator() {
        super("$LiteralChain", SqlKind.LITERAL_CHAIN, 80, true, ReturnTypes.ARG0, InferTypes.FIRST_KNOWN, OperandTypes.VARIADIC);
    }

    private boolean argTypesValid(SqlCallBinding callBinding) {
        if (callBinding.getOperandCount() < 2) {
            return true;
        }
        List<SqlNode> operandList = callBinding.getCall().getOperandList();
        RelDataType firstType = null;
        for (Ord<SqlNode> operand : Ord.zip(operandList)) {
            RelDataType type = callBinding.getValidator().deriveType(callBinding.getScope(), (SqlNode)operand.e);
            if (operand.i == 0) {
                firstType = type;
                continue;
            }
            if (SqlTypeUtil.sameNamedType(firstType, type)) continue;
            return false;
        }
        return true;
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (!this.argTypesValid(callBinding)) {
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        return true;
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType ret = opBinding.getOperandType(0);
        SqlTypeName typeName = ret.getSqlTypeName();
        assert (typeName.allowsPrecNoScale()) : "LiteralChain has impossible operand type " + (Object)((Object)typeName);
        int size = 0;
        for (RelDataType type : opBinding.collectOperandTypes()) {
            size += type.getPrecision();
            assert (type.getSqlTypeName().equals((Object)typeName));
        }
        return opBinding.getTypeFactory().createSqlType(typeName, size);
    }

    public String getAllowedSignatures(String opName) {
        return opName + "(...)";
    }

    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        List<SqlNode> operandList = call.getOperandList();
        for (int i = 1; i < operandList.size(); ++i) {
            SqlParserPos prevPos = operandList.get(i - 1).getParserPosition();
            SqlNode operand = operandList.get(i);
            SqlParserPos pos = operand.getParserPosition();
            if (pos.getLineNum() > prevPos.getLineNum()) continue;
            throw validator.newValidationError(operand, Static.RESOURCE.stringFragsOnSameLine());
        }
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList("", "");
        SqlCollation collation = null;
        List<SqlNode> rands = call.getOperandList();
        for (Ord<SqlNode> operand : Ord.zip(rands)) {
            SqlLiteral rand = (SqlLiteral)operand.e;
            if (operand.i > 0) {
                writer.newlineAndIndent();
            }
            if (rand instanceof SqlCharStringLiteral) {
                NlsString nls = ((SqlCharStringLiteral)rand).getNlsString();
                if (operand.i == 0) {
                    collation = nls.getCollation();
                    writer.literal(nls.asSql(true, false));
                    continue;
                }
                writer.literal(nls.asSql(false, false));
                continue;
            }
            if (operand.i == 0) {
                rand.unparse(writer, leftPrec, rightPrec);
                continue;
            }
            if (rand.getTypeName() == SqlTypeName.BINARY) {
                BitString bs = (BitString)rand.getValue();
                writer.literal("'" + bs.toHexString() + "'");
                continue;
            }
            writer.literal("'" + rand.toValue() + "'");
        }
        if (collation != null) {
            collation.unparse(writer, 0, 0);
        }
        writer.endList(frame);
    }

    public static SqlLiteral concatenateOperands(SqlCall call) {
        List<SqlNode> operandList = call.getOperandList();
        assert (operandList.size() > 0);
        assert (operandList.get(0) instanceof SqlLiteral) : operandList.get(0).getClass();
        return SqlUtil.concatenateLiterals(Util.cast(operandList, SqlLiteral.class));
    }
}

