/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.fun;

import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;

public class SqlCountAggFunction
extends SqlAggFunction {
    public SqlCountAggFunction() {
        super("COUNT", SqlKind.OTHER_FUNCTION, ReturnTypes.BIGINT, null, SqlValidator.STRICT ? OperandTypes.ANY : OperandTypes.ONE_OR_MORE, SqlFunctionCategory.NUMERIC);
    }

    public SqlSyntax getSyntax() {
        return SqlSyntax.FUNCTION_STAR;
    }

    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return typeFactory.createSqlType(SqlTypeName.BIGINT);
    }

    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        if (call.isCountStar()) {
            return validator.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
        }
        return super.deriveType(validator, scope, call);
    }
}

