/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlSetOption
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("SET_OPTION", SqlKind.SET_OPTION);
    String scope;
    String name;
    SqlNode value;

    public SqlSetOption(SqlParserPos pos, String scope, String name, SqlNode value) {
        super(pos);
        this.scope = scope;
        this.name = name;
        this.value = value;
        assert (scope != null);
        assert (name != null);
        assert (value != null);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.SET_OPTION;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(new SqlIdentifier(this.scope, SqlParserPos.ZERO), new SqlIdentifier(this.name, SqlParserPos.ZERO), this.value);
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.scope = ((SqlIdentifier)operand).getSimple();
                break;
            }
            case 1: {
                this.name = ((SqlIdentifier)operand).getSimple();
                break;
            }
            case 2: {
                this.value = operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ALTER");
        writer.keyword(this.getScope());
        writer.keyword("SET");
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE);
        writer.identifier(this.getName());
        writer.sep("=");
        this.value.unparse(writer, leftPrec, rightPrec);
        writer.endList(frame);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validate(this.value);
    }

    public String getName() {
        return this.name;
    }

    public String getScope() {
        return this.scope;
    }

    public SqlNode getValue() {
        return this.value;
    }
}

