/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import net.hydromatic.linq4j.Ord;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlBinaryOperator;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlWindow;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.util.SqlBasicVisitor;
import org.eigenbase.sql.util.SqlVisitor;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.Static;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlOverOperator
extends SqlBinaryOperator {
    public SqlOverOperator() {
        super("OVER", SqlKind.OVER, 20, true, ReturnTypes.ARG0_FORCE_NULLABLE, null, (SqlOperandTypeChecker)OperandTypes.ANY_ANY);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        assert (call.getOperator() == this);
        assert (call.operandCount() == 2);
        SqlCall aggCall = (SqlCall)call.operand(0);
        if (!aggCall.getOperator().isAggregator()) {
            throw validator.newValidationError(aggCall, Static.RESOURCE.overNonAggregate());
        }
        validator.validateWindow((SqlNode)call.operand(1), scope, aggCall);
        validator.validateAggregateParams(aggCall, scope);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        this.validateOperands(validator, scope, call);
        Object agg = call.operand(0);
        if (!(agg instanceof SqlCall)) {
            throw new IllegalStateException("Argument to SqlOverOperator should be SqlCall, got " + agg.getClass() + ": " + agg);
        }
        Object window = call.operand(1);
        SqlWindow w = validator.resolveWindow((SqlNode)window, scope, false);
        final int groupCount = w.isAlwaysNonEmpty() ? 1 : 0;
        SqlCall aggCall = (SqlCall)agg;
        SqlCallBinding opBinding = new SqlCallBinding(validator, scope, aggCall){

            public int getGroupCount() {
                return groupCount;
            }
        };
        RelDataType ret = aggCall.getOperator().inferReturnType(opBinding);
        validator.setValidatedNodeType(call, ret);
        validator.setValidatedNodeType((SqlNode)agg, ret);
        return ret;
    }

    @Override
    public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
        if (onlyExpressions) {
            for (Ord<SqlNode> operand : Ord.zip(call.getOperandList())) {
                if (operand == null || operand.i == 1 && operand.e instanceof SqlIdentifier) continue;
                argHandler.visitChild(visitor, call, operand.i, (SqlNode)operand.e);
            }
        } else {
            super.acceptCall(visitor, call, onlyExpressions, argHandler);
        }
    }
}

