/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.util.List;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.ImmutableNullableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlInsert
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("INSERT", SqlKind.INSERT);
    SqlNodeList keywords;
    SqlIdentifier targetTable;
    SqlNode source;
    SqlNodeList columnList;

    public SqlInsert(SqlParserPos pos, SqlNodeList keywords, SqlIdentifier targetTable, SqlNode source, SqlNodeList columnList) {
        super(pos);
        this.keywords = keywords;
        this.targetTable = targetTable;
        this.source = source;
        this.columnList = columnList;
        assert (keywords != null);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.INSERT;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.keywords, this.targetTable, this.source, this.columnList);
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.keywords = (SqlNodeList)operand;
                break;
            }
            case 1: {
                this.targetTable = (SqlIdentifier)operand;
                break;
            }
            case 2: {
                this.source = operand;
                break;
            }
            case 3: {
                this.columnList = (SqlNodeList)operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public SqlIdentifier getTargetTable() {
        return this.targetTable;
    }

    public SqlNode getSource() {
        return this.source;
    }

    public void setSource(SqlSelect source) {
        this.source = source;
    }

    public SqlNodeList getTargetColumnList() {
        return this.columnList;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.startList(SqlWriter.FrameTypeEnum.SELECT);
        writer.sep("INSERT INTO");
        int opLeft = this.getOperator().getLeftPrec();
        int opRight = this.getOperator().getRightPrec();
        this.targetTable.unparse(writer, opLeft, opRight);
        if (this.columnList != null) {
            this.columnList.unparse(writer, opLeft, opRight);
        }
        writer.newlineAndIndent();
        this.source.unparse(writer, opLeft, opRight);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateInsert(this);
    }
}

