/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import net.hydromatic.linq4j.Ord;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.type.SqlOperandTypeInference;
import org.eigenbase.sql.type.SqlReturnTypeInference;

public class SqlInfixOperator
extends SqlSpecialOperator {
    private final String[] names;

    protected SqlInfixOperator(String[] names, SqlKind kind, int precedence, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        super(names[0], kind, precedence, true, returnTypeInference, operandTypeInference, operandTypeChecker);
        assert (names.length > 1);
        this.names = names;
    }

    public SqlSyntax getSyntax() {
        return SqlSyntax.SPECIAL;
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == this.names.length + 1);
        boolean needWhitespace = this.needsSpace();
        for (Ord<SqlNode> operand : Ord.zip(call.getOperandList())) {
            if (operand.i > 0) {
                writer.setNeedWhitespace(needWhitespace);
                writer.keyword(this.names[operand.i - 1]);
                writer.setNeedWhitespace(needWhitespace);
            }
            ((SqlNode)operand.e).unparse(writer, leftPrec, this.getLeftPrec());
        }
    }

    boolean needsSpace() {
        return true;
    }
}

