/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.runtime.Hook;
import net.hydromatic.optiq.runtime.Utilities;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ClassBodyEvaluator;
import org.codehaus.janino.Scanner;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexExecutable {
    private final Function1<DataContext, Object[]> compiledFunction;
    private final String code;
    private DataContext dataContext;

    public RexExecutable(String code, Object reason) {
        try {
            this.compiledFunction = (Function1)ClassBodyEvaluator.createFastClassBodyEvaluator(new Scanner(null, new StringReader(code)), "Reducer", Utilities.class, new Class[]{Function1.class, Serializable.class}, this.getClass().getClassLoader());
        }
        catch (CompileException e) {
            throw new RuntimeException("While compiling " + reason, e);
        }
        catch (IOException e) {
            throw new RuntimeException("While compiling " + reason, e);
        }
        this.code = code;
    }

    public void setDataContext(DataContext dataContext) {
        this.dataContext = dataContext;
    }

    public void reduce(RexBuilder rexBuilder, List<RexNode> constExps, List<RexNode> reducedValues) {
        Object[] values = (Object[])this.compiledFunction.apply(this.dataContext);
        assert (values.length == constExps.size());
        List<Object> valueList = Arrays.asList(values);
        for (Pair<RexNode, Object> value : Pair.zip(constExps, valueList)) {
            reducedValues.add(rexBuilder.makeLiteral(value.right, ((RexNode)value.left).getType(), true));
        }
        Hook.EXPRESSION_REDUCER.run(Pair.of(this.code, values));
    }
}

