/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.resource.Resources;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.util.EigenbaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexCallBinding
extends SqlOperatorBinding {
    private final List<RexNode> operands;

    public RexCallBinding(RelDataTypeFactory typeFactory, SqlOperator sqlOperator, List<? extends RexNode> operands) {
        super(typeFactory, sqlOperator);
        this.operands = ImmutableList.copyOf(operands);
    }

    @Override
    public int getIntLiteralOperand(int ordinal) {
        return RexLiteral.intValue(this.operands.get(ordinal));
    }

    @Override
    public boolean isOperandNull(int ordinal, boolean allowCast) {
        return RexUtil.isNullLiteral(this.operands.get(ordinal), allowCast);
    }

    @Override
    public int getOperandCount() {
        return this.operands.size();
    }

    @Override
    public RelDataType getOperandType(int ordinal) {
        return this.operands.get(ordinal).getType();
    }

    @Override
    public EigenbaseException newError(Resources.ExInst<Object> e) {
        return SqlUtil.newContextException(SqlParserPos.ZERO, e);
    }
}

