/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resource;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resources {
    private static final ThreadLocal<Locale> MAP_THREAD_TO_LOCALE = new ThreadLocal();

    protected static Locale getThreadOrDefaultLocale() {
        Locale locale = Resources.getThreadLocale();
        if (locale == null) {
            return Locale.getDefault();
        }
        return locale;
    }

    public static Locale getThreadLocale() {
        return MAP_THREAD_TO_LOCALE.get();
    }

    public static <T> T create(final String base, Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.equals(BuiltinMethod.OBJECT_TO_STRING.method)) {
                    return this.toString();
                }
                Class<?> returnType = method.getReturnType();
                Class[] types = new Class[]{String.class, Locale.class, Method.class, Object[].class};
                Constructor<?> constructor = returnType.getConstructor(types);
                return constructor.newInstance(base, Resources.getThreadOrDefaultLocale(), method, args != null ? args : new Object[]{});
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum BuiltinMethod {
        OBJECT_TO_STRING(Object.class, "toString", new Class[0]);

        public final Method method;

        private BuiltinMethod(Class clazz, String methodName, Class ... argumentTypes) {
            this.method = BuiltinMethod.lookupMethod(clazz, methodName, argumentTypes);
        }

        public static Method lookupMethod(Class clazz, String methodName, Class ... argumentTypes) {
            try {
                return clazz.getMethod(methodName, argumentTypes);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("while resolving method '" + methodName + Arrays.toString(argumentTypes) + "' in class " + clazz, e);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Property {
        public String name();

        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Resource {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface BaseMessage {
        public String value();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Validation {
        BUNDLE_HAS_RESOURCE,
        AT_LEAST_ONE,
        MESSAGE_SPECIFIED,
        EVEN_QUOTES,
        MESSAGE_MATCH,
        CREATE_EXCEPTION,
        ARGUMENT_MATCH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExInst<T extends Exception>
    extends ExInstWithCause<T> {
        public Exception ex() {
            return this.ex(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExInstWithCause<T extends Exception>
    extends Inst {
        public T ex(Throwable cause) {
            try {
                Constructor constructor;
                Class exceptionClass = ExInstWithCause.getExceptionClass(this.method.getGenericReturnType());
                String str = this.str();
                boolean causeInConstructor = false;
                try {
                    constructor = exceptionClass.getConstructor(String.class, Throwable.class);
                    causeInConstructor = true;
                }
                catch (NoSuchMethodException nsmStringThrowable) {
                    try {
                        constructor = exceptionClass.getConstructor(String.class);
                    }
                    catch (NoSuchMethodException nsmString) {
                        throw nsmStringThrowable;
                    }
                }
                if (causeInConstructor) {
                    return (T)((Exception)constructor.newInstance(str, cause));
                }
                Exception ex = (Exception)constructor.newInstance(str);
                if (cause != null) {
                    try {
                        ex.initCause(cause);
                    }
                    catch (IllegalStateException iae) {
                        // empty catch block
                    }
                }
                return (T)ex;
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }

        public static Class getExceptionClass(Type type) {
            Type type0 = type;
            do {
                if (!(type instanceof ParameterizedType)) continue;
                Type[] types = ((ParameterizedType)type).getActualTypeArguments();
                if (types.length >= 1 && types[0] instanceof Class && Throwable.class.isAssignableFrom((Class)types[0])) {
                    return (Class)types[0];
                }
                throw new IllegalStateException("Unable to find superclass ExInstWithCause for " + type);
            } while (!(type instanceof Class) || (type = ((Class)type).getGenericSuperclass()) != null);
            throw new IllegalStateException("Unable to find superclass ExInstWithCause for " + type0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Inst {
        protected final String base;
        private final Locale locale;
        protected final Method method;
        protected final Object[] args;

        public boolean equals(Object obj) {
            return this == obj || obj != null && obj.getClass() == this.getClass() && this.locale == ((Inst)obj).locale && this.method == ((Inst)obj).method && Arrays.equals(this.args, ((Inst)obj).args);
        }

        public int hashCode() {
            return Arrays.asList(this.locale, this.method, Arrays.asList(this.args)).hashCode();
        }

        public ResourceBundle bundle() {
            return ResourceBundle.getBundle(this.base, this.locale);
        }

        public String str() {
            String message = this.raw();
            MessageFormat format = new MessageFormat(message);
            format.setLocale(this.locale);
            return format.format(this.args);
        }

        public String raw() {
            try {
                return this.bundle().getString(this.key());
            }
            catch (MissingResourceException e) {
                return this.method.getAnnotation(BaseMessage.class).value();
            }
        }

        private String key() {
            Resource resource = this.method.getAnnotation(Resource.class);
            if (resource != null) {
                return resource.value();
            }
            String name = this.method.getName();
            return Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }

        public Map<String, String> getProperties() {
            Property property = this.method.getAnnotation(Property.class);
            if (property == null) {
                return Collections.emptyMap();
            }
            return Collections.singletonMap(property.name(), property.value());
        }
    }
}

