/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.reltype;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.hydromatic.linq4j.Ord;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelDataTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelCrossType
extends RelDataTypeImpl {
    public final ImmutableList<RelDataType> types;

    public RelCrossType(List<RelDataType> types, List<RelDataTypeField> fields) {
        super(fields);
        this.types = ImmutableList.copyOf(types);
        assert (types != null);
        assert (types.size() >= 1);
        for (RelDataType type : types) {
            assert (!(type instanceof RelCrossType));
        }
        this.computeDigest();
    }

    @Override
    public boolean isStruct() {
        return false;
    }

    @Override
    public List<RelDataTypeField> getFieldList() {
        return this.fieldList;
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("CrossType(");
        for (Ord<RelDataType> type : Ord.zip(this.types)) {
            if (type.i > 0) {
                sb.append(", ");
            }
            if (withDetail) {
                sb.append(((RelDataType)type.e).getFullTypeString());
                continue;
            }
            sb.append(((RelDataType)type.e).toString());
        }
        sb.append(")");
    }
}

