/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt.volcano;

import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptCostFactory;
import org.eigenbase.util.Util;

class VolcanoCost
implements RelOptCost {
    static final VolcanoCost INFINITY = new VolcanoCost(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY){

        public String toString() {
            return "{inf}";
        }
    };
    static final VolcanoCost HUGE = new VolcanoCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE){

        public String toString() {
            return "{huge}";
        }
    };
    static final VolcanoCost ZERO = new VolcanoCost(0.0, 0.0, 0.0){

        public String toString() {
            return "{0}";
        }
    };
    static final VolcanoCost TINY = new VolcanoCost(1.0, 1.0, 0.0){

        public String toString() {
            return "{tiny}";
        }
    };
    public static final RelOptCostFactory FACTORY = new Factory();
    final double cpu;
    final double io;
    final double rowCount;

    VolcanoCost(double rowCount, double cpu, double io) {
        this.rowCount = rowCount;
        this.cpu = cpu;
        this.io = io;
    }

    public double getCpu() {
        return this.cpu;
    }

    public boolean isInfinite() {
        return this == INFINITY || this.rowCount == Double.POSITIVE_INFINITY || this.cpu == Double.POSITIVE_INFINITY || this.io == Double.POSITIVE_INFINITY;
    }

    public double getIo() {
        return this.io;
    }

    public boolean isLe(RelOptCost other) {
        VolcanoCost that = (VolcanoCost)other;
        return this == that || this.rowCount <= that.rowCount;
    }

    public boolean isLt(RelOptCost other) {
        VolcanoCost that = (VolcanoCost)other;
        return this.rowCount < that.rowCount;
    }

    public double getRows() {
        return this.rowCount;
    }

    public int hashCode() {
        return Util.hashCode(this.rowCount) + Util.hashCode(this.cpu) + Util.hashCode(this.io);
    }

    public RelOptCost multiplyBy(double factor) {
        if (this == INFINITY) {
            return this;
        }
        return new VolcanoCost(this.rowCount * factor, this.cpu * factor, this.io * factor);
    }

    public RelOptCost plus(RelOptCost other) {
        VolcanoCost that = (VolcanoCost)other;
        if (this == INFINITY || that == INFINITY) {
            return INFINITY;
        }
        return new VolcanoCost(this.rowCount + that.rowCount, this.cpu + that.cpu, this.io + that.io);
    }

    public String toString() {
        return "{" + this.rowCount + " rows, " + this.cpu + " cpu, " + this.io + " io}";
    }

    private static class Factory
    implements RelOptCostFactory {
        private Factory() {
        }

        public RelOptCost makeHugeCost() {
            return HUGE;
        }

        public RelOptCost makeInfiniteCost() {
            return INFINITY;
        }

        public RelOptCost makeTinyCost() {
            return TINY;
        }

        public RelOptCost makeZeroCost() {
            return ZERO;
        }
    }
}

