/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt.hep;

import java.util.BitSet;
import java.util.List;
import org.eigenbase.rel.AbstractRelNode;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HepRelVertex
extends AbstractRelNode {
    private RelNode currentRel;

    HepRelVertex(RelNode rel) {
        super(rel.getCluster(), rel.getTraitSet());
        this.currentRel = rel;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (traitSet.equals(this.traitSet));
        assert (inputs.equals(this.getInputs()));
        return this;
    }

    @Override
    public double getRows() {
        return RelMetadataQuery.getRowCount(this.currentRel);
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.currentRel.getRowType();
    }

    @Override
    public boolean isDistinct() {
        return this.currentRel.isDistinct();
    }

    @Override
    public boolean isKey(BitSet columns) {
        return this.currentRel.isKey(columns);
    }

    @Override
    protected String computeDigest() {
        return "HepRelVertex(" + this.currentRel + ")";
    }

    void replaceRel(RelNode newRel) {
        this.currentRel = newRel;
    }

    public RelNode getCurrentRel() {
        return this.currentRel;
    }
}

