/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt;

import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.impl.StarTable;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelShuttleImpl;
import org.eigenbase.rel.TableAccessRel;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.rel.rules.PullUpProjectsAboveJoinRule;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.hep.HepPlanner;
import org.eigenbase.relopt.hep.HepProgram;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.util.Util;
import org.eigenbase.util.mapping.Mappings;

public class RelOptMaterialization {
    public final RelNode tableRel;
    public final RelOptTable starRelOptTable;
    public final StarTable starTable;
    public final RelOptTable table;
    public final RelNode queryRel;

    public RelOptMaterialization(RelNode tableRel, RelNode queryRel, RelOptTable starRelOptTable) {
        this.tableRel = tableRel;
        this.starRelOptTable = starRelOptTable;
        if (starRelOptTable == null) {
            this.starTable = null;
        } else {
            this.starTable = starRelOptTable.unwrap(StarTable.class);
            assert (this.starTable != null);
        }
        this.table = tableRel.getTable();
        this.queryRel = queryRel;
    }

    public static RelNode tryUseStar(RelNode rel, final RelOptTable starRelOptTable) {
        final StarTable starTable = starRelOptTable.unwrap(StarTable.class);
        assert (starTable != null);
        return rel.accept(new RelShuttleImpl(){

            public RelNode visit(TableAccessRelBase scan) {
                RelOptTable relOptTable = scan.getTable();
                Table table = relOptTable.unwrap(Table.class);
                if (table.equals(starTable.tables.get(0))) {
                    Mappings.TargetMapping mapping = Mappings.createShiftMapping(starRelOptTable.getRowType().getFieldCount(), 0, 0, relOptTable.getRowType().getFieldCount());
                    return CalcRel.createProject(new TableAccessRel(scan.getCluster(), starRelOptTable), Mappings.asList(mapping.inverse()));
                }
                return scan;
            }

            public RelNode visit(JoinRel join) {
                RelNode rel;
                while ((rel = super.visit(join)) != join && rel instanceof JoinRel) {
                    join = (JoinRel)rel;
                    RelNode left = join.getLeft();
                    RelNode right = join.getRight();
                    try {
                        ProjectRel leftProject;
                        if (left instanceof TableAccessRelBase && right instanceof TableAccessRelBase) {
                            this.match(left, null, right, null, join.getCluster());
                        }
                        if (this.isProjectedTable(left) && right instanceof TableAccessRelBase) {
                            leftProject = (ProjectRel)left;
                            this.match(leftProject.getChild(), leftProject.getMapping(), right, null, join.getCluster());
                        }
                        if (left instanceof TableAccessRelBase && this.isProjectedTable(right)) {
                            ProjectRel rightProject = (ProjectRel)right;
                            this.match(left, null, rightProject.getChild(), rightProject.getMapping(), join.getCluster());
                        }
                        if (!this.isProjectedTable(left) || !this.isProjectedTable(right)) continue;
                        leftProject = (ProjectRel)left;
                        ProjectRel rightProject = (ProjectRel)right;
                        this.match(leftProject.getChild(), leftProject.getMapping(), rightProject.getChild(), rightProject.getMapping(), join.getCluster());
                    }
                    catch (Util.FoundOne e) {
                        return (RelNode)e.getNode();
                    }
                }
                return rel;
            }

            private boolean isProjectedTable(RelNode rel) {
                return rel instanceof ProjectRel && ((ProjectRel)rel).isMapping() && ((ProjectRel)rel).getChild() instanceof TableAccessRelBase;
            }

            private void match(RelNode left, Mappings.TargetMapping leftMapping, RelNode right, Mappings.TargetMapping rightMapping, RelOptCluster cluster) {
                if (leftMapping == null) {
                    leftMapping = Mappings.createIdentity(left.getRowType().getFieldCount());
                }
                if (rightMapping == null) {
                    rightMapping = Mappings.createIdentity(right.getRowType().getFieldCount());
                }
                RelOptTable leftRelOptTable = left.getTable();
                Table leftTable = leftRelOptTable.unwrap(Table.class);
                RelOptTable rightRelOptTable = right.getTable();
                Table rightTable = rightRelOptTable.unwrap(Table.class);
                if (leftTable instanceof StarTable && ((StarTable)leftTable).tables.contains(rightTable)) {
                    System.out.println("left: " + leftMapping);
                    System.out.println("right: " + rightMapping);
                    Mappings.TargetMapping mapping = Mappings.merge(leftMapping, Mappings.offset(rightMapping, ((StarTable)leftTable).columnOffset(rightTable), leftRelOptTable.getRowType().getFieldCount()));
                    throw new Util.FoundOne(CalcRel.createProject(new TableAccessRel(cluster, leftRelOptTable), Mappings.asList(mapping.inverse())));
                }
                if (rightTable instanceof StarTable && ((StarTable)rightTable).tables.contains(leftTable)) {
                    assert (false);
                    Mappings.TargetMapping mapping = Mappings.append(leftMapping, rightMapping);
                    throw new Util.FoundOne(CalcRel.createProject(new TableAccessRel(cluster, rightRelOptTable), Mappings.asList(mapping.inverse())));
                }
            }
        });
    }

    public static RelNode toLeafJoinForm(RelNode rel) {
        HepProgram program = HepProgram.builder().addRuleInstance(PullUpProjectsAboveJoinRule.RIGHT_PROJECT).addRuleInstance(PullUpProjectsAboveJoinRule.LEFT_PROJECT).build();
        HepPlanner planner = new HepPlanner(program, rel.getCluster().getPlanner().getContext());
        planner.setRoot(rel);
        System.out.println(RelOptUtil.dumpPlan("before", rel, false, SqlExplainLevel.DIGEST_ATTRIBUTES));
        RelNode rel2 = planner.findBestExp();
        System.out.println(RelOptUtil.dumpPlan("after", rel2, false, SqlExplainLevel.DIGEST_ATTRIBUTES));
        return rel2;
    }
}

