/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.rules.PushProjector;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexOver;

public class PushProjectPastFilterRule
extends RelOptRule {
    public static final PushProjectPastFilterRule INSTANCE = new PushProjectPastFilterRule(PushProjector.ExprCondition.FALSE);
    private final PushProjector.ExprCondition preserveExprCondition;

    protected PushProjectPastFilterRule(PushProjector.ExprCondition preserveExprCondition) {
        super(PushProjectPastFilterRule.operand(ProjectRel.class, PushProjectPastFilterRule.operand(FilterRel.class, PushProjectPastFilterRule.any()), new RelOptRuleOperand[0]));
        this.preserveExprCondition = preserveExprCondition;
    }

    public void onMatch(RelOptRuleCall call) {
        FilterRel filterRel;
        ProjectRel origProj;
        if (call.rels.length == 2) {
            origProj = (ProjectRel)call.rel(0);
            filterRel = (FilterRel)call.rel(1);
        } else {
            origProj = null;
            filterRel = (FilterRel)call.rel(0);
        }
        RelNode rel = filterRel.getChild();
        RexNode origFilter = filterRel.getCondition();
        if (origProj != null && RexOver.containsOver(origProj.getProjects(), null)) {
            return;
        }
        PushProjector pushProjector = new PushProjector(origProj, origFilter, rel, this.preserveExprCondition);
        RelNode topProject = pushProjector.convertProject(null);
        if (topProject != null) {
            call.transformTo(topProject);
        }
    }
}

