/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.metadata;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import net.hydromatic.optiq.BuiltinMethod;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.Metadata;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.util.ReflectiveVisitor;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveRelMetadataProvider
implements RelMetadataProvider,
ReflectiveVisitor {
    private static final Comparator<Class<RelNode>> SUPERCLASS_COMPARATOR = new Comparator<Class<RelNode>>(){

        @Override
        public int compare(Class<RelNode> c1, Class<RelNode> c2) {
            return c1 == c2 ? 0 : (c2.isAssignableFrom(c1) ? -1 : 1);
        }
    };
    private final ImmutableMap<Class<RelNode>, Function<RelNode, Metadata>> map;
    private final Class<?> metadataClass0;

    protected ReflectiveRelMetadataProvider(ImmutableMap<Class<RelNode>, Function<RelNode, Metadata>> map, Class<?> metadataClass0) {
        assert (!map.isEmpty()) : "are your methods named wrong?";
        this.map = map;
        this.metadataClass0 = metadataClass0;
    }

    public static RelMetadataProvider reflectiveSource(Method method, final Object target) {
        final Class<?> metadataClass0 = method.getDeclaringClass();
        assert (Metadata.class.isAssignableFrom(metadataClass0));
        TreeMap<Class<?>, 2> treeMap = Maps.newTreeMap(SUPERCLASS_COMPARATOR);
        for (final Method method1 : target.getClass().getMethods()) {
            Class<?>[] parameterTypes;
            Class<?>[] parameterTypes1;
            if (!method1.getName().equals(method.getName()) || (method1.getModifiers() & 8) != 0 || (method1.getModifiers() & 1) == 0 || (parameterTypes1 = method1.getParameterTypes()).length != (parameterTypes = method.getParameterTypes()).length + 1 || !RelNode.class.isAssignableFrom(parameterTypes1[0]) || !Util.skip(Arrays.asList(parameterTypes1)).equals(Arrays.asList(parameterTypes))) continue;
            Class<?> key = parameterTypes1[0];
            Function<RelNode, Metadata> function = new Function<RelNode, Metadata>(){

                public Metadata apply(final RelNode rel) {
                    return (Metadata)Proxy.newProxyInstance(metadataClass0.getClassLoader(), new Class[]{metadataClass0}, new InvocationHandler(){

                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            Object[] args1;
                            if (method.equals(BuiltinMethod.METADATA_REL.method)) {
                                return rel;
                            }
                            if (args == null) {
                                args1 = new Object[]{rel};
                            } else {
                                args1 = new Object[args.length + 1];
                                args1[0] = rel;
                                System.arraycopy(args, 0, args1, 1, args.length);
                            }
                            return method1.invoke(target, args1);
                        }
                    });
                }
            };
            treeMap.put(key, function);
        }
        ImmutableMap<Class<RelNode>, Function<RelNode, Metadata>> map = ImmutableMap.copyOf(treeMap);
        return new ReflectiveRelMetadataProvider(map, metadataClass0);
    }

    @Override
    public Function<RelNode, Metadata> apply(Class<? extends RelNode> relClass, Class<? extends Metadata> metadataClass) {
        if (metadataClass == this.metadataClass0) {
            Function<RelNode, Metadata> function = this.map.get(relClass);
            if (function != null) {
                return function;
            }
            for (Map.Entry entry : this.map.entrySet()) {
                if (!((Class)entry.getKey()).isAssignableFrom(relClass)) continue;
                return (Function)entry.getValue();
            }
        }
        return null;
    }
}

