/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import java.util.Collections;
import java.util.List;
import net.hydromatic.optiq.prepare.Prepare;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableModificationRelBase
extends SingleRel {
    protected Prepare.CatalogReader catalogReader;
    protected final RelOptTable table;
    private final Operation operation;
    private final List<String> updateColumnList;
    private final boolean flattened;

    protected TableModificationRelBase(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, Operation operation, List<String> updateColumnList, boolean flattened) {
        super(cluster, traits, child);
        this.table = table;
        this.catalogReader = catalogReader;
        this.operation = operation;
        this.updateColumnList = updateColumnList;
        if (table.getRelOptSchema() != null) {
            cluster.getPlanner().registerSchema(table.getRelOptSchema());
        }
        this.flattened = flattened;
    }

    public Prepare.CatalogReader getCatalogReader() {
        return this.catalogReader;
    }

    @Override
    public RelOptTable getTable() {
        return this.table;
    }

    public List<String> getUpdateColumnList() {
        return this.updateColumnList;
    }

    public boolean isFlattened() {
        return this.flattened;
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public RelDataType deriveRowType() {
        return RelOptUtil.createDmlRowType(SqlKind.INSERT, this.getCluster().getTypeFactory());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("table", this.table.getQualifiedName()).item("operation", (Object)this.getOperation()).item("updateColumnList", this.updateColumnList == null ? Collections.EMPTY_LIST : this.updateColumnList).item("flattened", this.flattened);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        INSERT,
        UPDATE,
        DELETE,
        MERGE;

    }
}

