/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import net.hydromatic.linq4j.Ord;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelShuttle;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.rex.RexNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortRel
extends SingleRel {
    protected final RelCollation collation;
    protected final ImmutableList<RexNode> fieldExps;
    public final RexNode offset;
    public final RexNode fetch;

    public SortRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelCollation collation) {
        this(cluster, traits, child, collation, null, null);
    }

    public SortRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traits, child);
        this.collation = collation;
        this.offset = offset;
        this.fetch = fetch;
        assert (traits.containsIfApplicable(collation)) : "traits=" + traits + ", collation=" + collation;
        assert (fetch != null || offset != null || !collation.getFieldCollations().isEmpty()) : "trivial sort";
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RelFieldCollation field : collation.getFieldCollations()) {
            int index = field.getFieldIndex();
            builder.add(cluster.getRexBuilder().makeInputRef(child, index));
        }
        this.fieldExps = builder.build();
    }

    @Override
    public SortRel copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, SortRel.sole(inputs), this.collation);
    }

    public SortRel copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation) {
        return this.copy(traitSet, newInput, newCollation, this.offset, this.fetch);
    }

    public SortRel copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new SortRel(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public List<RexNode> getChildExps() {
        return this.fieldExps;
    }

    public RelCollation getCollation() {
        return this.collation;
    }

    @Override
    public List<RelCollation> getCollationList() {
        return Collections.singletonList(this.getCollation());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        assert (this.fieldExps.size() == this.collation.getFieldCollations().size());
        if (pw.nest()) {
            pw.item("collation", this.collation);
        } else {
            for (Ord<RexNode> ord : Ord.zip(this.fieldExps)) {
                pw.item("sort" + ord.i, ord.e);
            }
            for (Ord<Object> ord : Ord.zip(this.collation.getFieldCollations())) {
                pw.item("dir" + ord.i, ((RelFieldCollation)ord.e).shortString());
            }
        }
        pw.itemIf("offset", this.offset, this.offset != null);
        pw.itemIf("fetch", this.fetch, this.fetch != null);
        return pw;
    }
}

