/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.ImmutableList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.hydromatic.linq4j.Ord;
import org.eigenbase.rel.AbstractRelNode;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SetOpRel
extends AbstractRelNode {
    protected ImmutableList<RelNode> inputs;
    public final boolean all;

    protected SetOpRel(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
        super(cluster, traits);
        this.inputs = ImmutableList.copyOf(inputs);
        this.all = all;
    }

    public abstract SetOpRel copy(RelTraitSet var1, List<RelNode> var2, boolean var3);

    @Override
    public SetOpRel copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, inputs, this.all);
    }

    @Override
    public void replaceInput(int ordinalInParent, RelNode p) {
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>(this.inputs);
        newInputs.set(ordinalInParent, p);
        this.inputs = ImmutableList.copyOf(newInputs);
        this.recomputeDigest();
    }

    @Override
    public boolean isKey(BitSet columns) {
        return !this.all && columns.nextClearBit(0) >= this.getRowType().getFieldCount();
    }

    @Override
    public List<RelNode> getInputs() {
        return this.inputs;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (Ord<RelNode> ord : Ord.zip(this.inputs)) {
            pw.input("input#" + ord.i, (RelNode)ord.e);
        }
        return pw.item("all", this.all);
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.getCluster().getTypeFactory().leastRestrictive((List<RelDataType>)new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                return ((RelNode)SetOpRel.this.inputs.get(index)).getRowType();
            }

            @Override
            public int size() {
                return SetOpRel.this.inputs.size();
            }
        });
    }
}

