/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eigenbase.rel.RelNode;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.trace.EigenbaseTrace;

public class RelImplementorImpl {
    protected static final Logger LOGGER = EigenbaseTrace.getRelImplementorTracer();
    protected final Map<String, Frame> mapCorrel2Frame = new HashMap<String, Frame>();
    protected final Map<RelNode, Frame> mapRel2Frame = new HashMap<RelNode, Frame>();
    protected final RexBuilder rexBuilder;

    public RelImplementorImpl(RexBuilder rexBuilder) {
        this.rexBuilder = rexBuilder;
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.rexBuilder.getTypeFactory();
    }

    protected void createFrame(RelNode parent, int ordinal, RelNode child) {
        Frame frame = new Frame(child, parent, ordinal);
        this.mapRel2Frame.put(child, frame);
        String correl = child.getCorrelVariable();
        if (correl != null && this.mapCorrel2Frame.get(correl) == null) {
            this.mapCorrel2Frame.put(correl, frame);
        }
    }

    protected static class Frame {
        public final RelNode parent;
        public final RelNode rel;
        public final int ordinal;

        Frame(RelNode child, RelNode parent, int ordinal) {
            this.rel = child;
            this.parent = parent;
            this.ordinal = ordinal;
        }
    }
}

