/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelCollationTraitDef;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.RelTraitDef;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelCollationImpl
implements RelCollation {
    public static final RelCollation EMPTY = (RelCollation)RelCollationTraitDef.INSTANCE.canonize(new RelCollationImpl(ImmutableList.<RelFieldCollation>of()));
    public static final RelCollation PRESERVE = (RelCollation)RelCollationTraitDef.INSTANCE.canonize(new RelCollationImpl((ImmutableList)ImmutableList.of(new RelFieldCollation(-1))){

        public String toString() {
            return "PRESERVE";
        }
    });
    private final ImmutableList<RelFieldCollation> fieldCollations;

    protected RelCollationImpl(ImmutableList<RelFieldCollation> fieldCollations) {
        this.fieldCollations = fieldCollations;
    }

    public static RelCollation of(List<RelFieldCollation> fieldCollations) {
        return new RelCollationImpl(ImmutableList.copyOf(fieldCollations));
    }

    @Override
    public RelTraitDef getTraitDef() {
        return RelCollationTraitDef.INSTANCE;
    }

    @Override
    public List<RelFieldCollation> getFieldCollations() {
        return this.fieldCollations;
    }

    public int hashCode() {
        return this.fieldCollations.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RelCollationImpl) {
            RelCollationImpl that = (RelCollationImpl)obj;
            return this.fieldCollations.equals(that.fieldCollations);
        }
        return false;
    }

    @Override
    public void register(RelOptPlanner planner) {
    }

    @Override
    public boolean subsumes(RelTrait trait) {
        return this == trait || trait instanceof RelCollationImpl && Util.startsWith(this.fieldCollations, ((RelCollationImpl)trait).fieldCollations);
    }

    @Override
    public String toString() {
        Iterator it = this.fieldCollations.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            RelFieldCollation e = (RelFieldCollation)it.next();
            sb.append(e.getFieldIndex());
            if (e.direction != RelFieldCollation.Direction.ASCENDING || e.nullDirection != RelFieldCollation.NullDirection.UNSPECIFIED) {
                sb.append(' ').append(e.shortString());
            }
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public static boolean isValid(RelDataType rowType, List<RelCollation> collationList, boolean fail) {
        int fieldCount = rowType.getFieldCount();
        for (RelCollation collation : collationList) {
            for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
                int index = fieldCollation.getFieldIndex();
                if (index >= 0 && index < fieldCount) continue;
                assert (!fail);
                return false;
            }
        }
        return true;
    }
}

