/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelShuttle;
import org.eigenbase.rel.RelVisitor;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.RelWriterImpl;
import org.eigenbase.rel.metadata.Metadata;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.ConventionTraitDef;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.trace.EigenbaseTrace;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRelNode
implements RelNode {
    static int nextId = 0;
    private static final Logger LOGGER = EigenbaseTrace.getPlannerTracer();
    private String desc;
    protected RelDataType rowType;
    protected String digest;
    private final RelOptCluster cluster;
    protected int id;
    private String correlVariable;
    protected RelTraitSet traitSet;

    public AbstractRelNode(RelOptCluster cluster, RelTraitSet traitSet) {
        assert (cluster != null);
        this.cluster = cluster;
        this.traitSet = traitSet;
        this.id = nextId++;
        this.desc = this.digest = this.getRelTypeName() + "#" + this.id;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("new " + this.digest);
        }
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        if (this.getInputs().equals(inputs) && traitSet == this.getTraitSet()) {
            return this;
        }
        throw new AssertionError((Object)("Relational expression should override copy. Class=[" + this.getClass() + "]; traits=[" + this.getTraitSet() + "]; desired traits=[" + traitSet + "]"));
    }

    protected static <T> T sole(List<T> collection) {
        assert (collection.size() == 1);
        return collection.get(0);
    }

    @Override
    public List<RexNode> getChildExps() {
        return ImmutableList.of();
    }

    @Override
    public final RelOptCluster getCluster() {
        return this.cluster;
    }

    @Override
    public final Convention getConvention() {
        return this.traitSet.getTrait(ConventionTraitDef.INSTANCE);
    }

    @Override
    public RelTraitSet getTraitSet() {
        return this.traitSet;
    }

    @Override
    public void setCorrelVariable(String correlVariable) {
        this.correlVariable = correlVariable;
    }

    @Override
    public String getCorrelVariable() {
        return this.correlVariable;
    }

    @Override
    public boolean isDistinct() {
        return this.isKey(BitSets.range(this.getRowType().getFieldCount()));
    }

    @Override
    public boolean isKey(BitSet columns) {
        return false;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public RelNode getInput(int i) {
        List<RelNode> inputs = this.getInputs();
        return inputs.get(i);
    }

    @Override
    public void register(RelOptPlanner planner) {
        Util.discard(planner);
    }

    @Override
    public final String getRelTypeName() {
        String className = this.getClass().getName();
        int i = className.lastIndexOf("$");
        if (i >= 0) {
            return className.substring(i + 1);
        }
        i = className.lastIndexOf(".");
        if (i >= 0) {
            return className.substring(i + 1);
        }
        return className;
    }

    @Override
    public boolean isValid(boolean fail) {
        return true;
    }

    @Override
    public List<RelCollation> getCollationList() {
        return ImmutableList.of();
    }

    @Override
    public final RelDataType getRowType() {
        if (this.rowType == null) {
            this.rowType = this.deriveRowType();
            assert (this.rowType != null) : this;
        }
        return this.rowType;
    }

    protected RelDataType deriveRowType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RelNode> getInputs() {
        return Collections.emptyList();
    }

    @Override
    public double getRows() {
        return 1.0;
    }

    @Override
    public Set<String> getVariablesStopped() {
        return Collections.emptySet();
    }

    @Override
    public void collectVariablesUsed(Set<String> variableSet) {
    }

    @Override
    public void childrenAccept(RelVisitor visitor) {
        List<RelNode> inputs = this.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            visitor.visit(inputs.get(i), i, this);
        }
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public final <M extends Metadata> M metadata(Class<M> metadataClass) {
        M metadata = this.cluster.getMetadataFactory().query(this, metadataClass);
        assert (metadata != null) : "no provider found (rel=" + this + ", m=" + metadataClass + "); a backstop provider is recommended";
        return metadata;
    }

    @Override
    public void explain(RelWriter pw) {
        this.explainTerms(pw).done(this);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return pw;
    }

    @Override
    public RelNode onRegister(RelOptPlanner planner) {
        List<RelNode> oldInputs = this.getInputs();
        ArrayList<RelNode> inputs = new ArrayList<RelNode>(oldInputs.size());
        for (RelNode input : oldInputs) {
            RelNode e = planner.ensureRegistered(input, null);
            if (e != input) assert (RelOptUtil.equal("rowtype of rel before registration", input.getRowType(), "rowtype of rel after registration", e.getRowType(), true));
            inputs.add(e);
        }
        RelNode r = this;
        if (!Util.equalShallow(oldInputs, inputs)) {
            r = this.copy(this.getTraitSet(), inputs);
        }
        r.recomputeDigest();
        assert (r.isValid(true));
        return r;
    }

    @Override
    public String recomputeDigest() {
        String tempDigest = this.computeDigest();
        assert (tempDigest != null) : "post: return != null";
        String prefix = "rel#" + this.id + ":";
        this.desc = prefix + tempDigest;
        this.digest = this.desc.substring(prefix.length());
        return this.digest;
    }

    @Override
    public void replaceInput(int ordinalInParent, RelNode p) {
        throw Util.newInternal("replaceInput called on " + this);
    }

    public String toString() {
        return this.desc;
    }

    @Override
    public final String getDescription() {
        return this.desc;
    }

    @Override
    public final String getDigest() {
        return this.digest;
    }

    @Override
    public RelOptTable getTable() {
        return null;
    }

    protected String computeDigest() {
        StringWriter sw = new StringWriter();
        RelWriterImpl pw = new RelWriterImpl(new PrintWriter(sw), SqlExplainLevel.DIGEST_ATTRIBUTES, false){

            @Override
            protected void explain_(RelNode rel, List<Pair<String, Object>> values) {
                this.pw.write(AbstractRelNode.this.getRelTypeName());
                for (RelTrait trait : AbstractRelNode.this.traitSet) {
                    this.pw.write(".");
                    this.pw.write(trait.toString());
                }
                this.pw.write("(");
                int j = 0;
                for (Pair<String, Object> value : values) {
                    if (j++ > 0) {
                        this.pw.write(",");
                    }
                    this.pw.write((String)value.left + "=" + value.right);
                }
                this.pw.write(")");
            }
        };
        this.explain(pw);
        return sw.toString();
    }
}

