/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class AutoIndentWriter
extends FilterWriter {
    StringBuffer lineBuffer = new StringBuffer();
    int indentation = 0;
    List tabulatorBuffer = null;
    int tabulatorIndentation;

    public AutoIndentWriter(Writer out) {
        super(out);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        while (len > 0) {
            this.write(cbuf[off++]);
            --len;
        }
    }

    public void write(String str, int off, int len) throws IOException {
        while (len > 0) {
            this.write(str.charAt(off++));
            --len;
        }
    }

    public void write(int c) throws IOException {
        if (c == 10) {
            this.lineBuffer.append('\n');
            this.line(this.lineBuffer.toString());
            this.lineBuffer.setLength(0);
            return;
        }
        if (this.lineBuffer.length() > 0 && this.lineBuffer.charAt(this.lineBuffer.length() - 1) == '\r') {
            this.line(this.lineBuffer.toString());
            this.lineBuffer.setCharAt(0, (char)c);
            this.lineBuffer.setLength(1);
            return;
        }
        this.lineBuffer.append((char)c);
    }

    private void line(String line) throws IOException {
        if (this.tabulatorBuffer != null) {
            this.tabulatorBuffer.add(new StringBuffer(line.length()).append(line));
            if (line.charAt(0) == '\ufffd') {
                ++this.indentation;
                line = line.substring(1);
            }
            if (line.charAt(0) == '\ufffc' && --this.indentation < this.tabulatorIndentation) {
                this.flushTabulatorBuffer();
            }
        } else if (line.indexOf(65535) != -1) {
            if (line.charAt(0) == '\ufffd') {
                ++this.indentation;
                line = line.substring(1);
            }
            if (line.charAt(0) == '\ufffc') {
                --this.indentation;
                line = line.substring(1);
            }
            this.tabulatorBuffer = new ArrayList();
            this.tabulatorBuffer.add(new StringBuffer(line.length()).append(line));
            this.tabulatorIndentation = this.indentation;
        } else {
            if (line.charAt(0) == '\ufffe') {
                line = line.substring(1);
            }
            if (line.charAt(0) == '\ufffd') {
                ++this.indentation;
                line = line.substring(1);
            }
            if (line.charAt(0) == '\ufffc') {
                --this.indentation;
                line = line.substring(1);
            }
            if ("\r\n".indexOf(line.charAt(0)) == -1) {
                for (int i = 0; i < this.indentation; ++i) {
                    this.out.write("    ");
                }
            }
            this.out.write(line);
        }
    }

    private void flushTabulatorBuffer() throws IOException {
        int i;
        ArrayList lineGroups = new ArrayList();
        lineGroups.add(new ArrayList());
        Iterator it = this.tabulatorBuffer.iterator();
        while (it.hasNext()) {
            StringBuffer line = (StringBuffer)it.next();
            int idx = 0;
            if (line.charAt(0) == '\ufffd') {
                lineGroups.add(new ArrayList());
                ++idx;
            }
            if (line.charAt(idx) == '\ufffc') {
                this.resolveTabs((List)lineGroups.remove(lineGroups.size() - 1));
                ++idx;
            }
            if (line.charAt(idx) == '\ufffe') {
                List lg = (List)lineGroups.get(lineGroups.size() - 1);
                this.resolveTabs(lg);
                lg.clear();
                line.deleteCharAt(idx);
            }
            for (i = 0; i < line.length(); ++i) {
                if (line.charAt(i) != '\uffff') continue;
                ((List)lineGroups.get(lineGroups.size() - 1)).add(line);
            }
        }
        it = lineGroups.iterator();
        while (it.hasNext()) {
            this.resolveTabs((List)it.next());
        }
        int ind = this.tabulatorIndentation;
        Iterator it2 = this.tabulatorBuffer.iterator();
        while (it2.hasNext()) {
            String line = ((StringBuffer)it2.next()).toString();
            if (line.charAt(0) == '\ufffd') {
                ++ind;
                line = line.substring(1);
            }
            if (line.charAt(0) == '\ufffc') {
                --ind;
                line = line.substring(1);
            }
            if ("\r\n".indexOf(line.charAt(0)) == -1) {
                for (i = 0; i < ind; ++i) {
                    this.out.write("    ");
                }
            }
            this.out.write(line.toString());
        }
        this.tabulatorBuffer = null;
    }

    private void resolveTabs(List lineGroup) {
        int tabOffset;
        int i;
        int previousTab;
        int tabCount;
        StringBuffer line;
        ArrayList<Integer> tabulatorOffsets = new ArrayList<Integer>();
        Iterator it = lineGroup.iterator();
        while (it.hasNext()) {
            line = (StringBuffer)it.next();
            tabCount = 0;
            previousTab = 0;
            if (line.charAt(previousTab) == '\ufffd') {
                ++previousTab;
            }
            if (line.charAt(previousTab) == '\ufffc') {
                // empty if block
            }
            for (i = ++previousTab; i < line.length(); ++i) {
                if (line.charAt(i) != '\uffff') continue;
                tabOffset = i - previousTab;
                previousTab = i;
                if (tabCount >= tabulatorOffsets.size()) {
                    tabulatorOffsets.add(new Integer(tabOffset));
                } else if (tabOffset > (Integer)tabulatorOffsets.get(tabCount)) {
                    tabulatorOffsets.set(tabCount, new Integer(tabOffset));
                }
                ++tabCount;
            }
        }
        it = lineGroup.iterator();
        while (it.hasNext()) {
            line = (StringBuffer)it.next();
            tabCount = 0;
            previousTab = 0;
            if (line.charAt(previousTab) == '\ufffd') {
                ++previousTab;
            }
            if (line.charAt(previousTab) == '\ufffc') {
                // empty if block
            }
            for (i = ++previousTab; i < line.length(); ++i) {
                if (line.charAt(i) != '\uffff') continue;
                tabOffset = i - previousTab;
                int n = (Integer)tabulatorOffsets.get(tabCount++) - tabOffset;
                line.replace(i, i + 1, this.spaces(n));
                previousTab = i += n - 1;
            }
        }
    }

    private String spaces(int n) {
        if (n < 30) {
            return "                              ".substring(0, n);
        }
        char[] data = new char[n];
        Arrays.fill(data, ' ');
        return String.valueOf(data);
    }

    public void close() throws IOException {
        if (this.tabulatorBuffer != null) {
            this.flushTabulatorBuffer();
        }
        if (this.lineBuffer.length() > 0) {
            this.line(this.lineBuffer.toString());
        }
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }
}

