/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.IScriptEvaluator;
import org.codehaus.commons.compiler.Location;
import org.codehaus.janino.ClassBodyEvaluator;
import org.codehaus.janino.JaninoRuntimeException;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;

public class ScriptEvaluator
extends ClassBodyEvaluator
implements IScriptEvaluator {
    protected boolean[] optionalStaticMethod = null;
    protected Class[] optionalReturnTypes = null;
    protected String[] optionalMethodNames = null;
    protected String[][] optionalParameterNames = null;
    protected Class[][] optionalParameterTypes = null;
    protected Class[][] optionalThrownExceptions = null;
    private Method[] result = null;

    public ScriptEvaluator(String script, Class returnType, String[] parameterNames, Class[] parameterTypes, Class[] thrownExceptions) throws CompileException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.cook(script);
    }

    public ScriptEvaluator() {
    }

    public void setReturnType(Class returnType) {
        this.setReturnTypes(new Class[]{returnType});
    }

    public void setParameters(String[] parameterNames, Class[] parameterTypes) {
        this.setParameters(new String[][]{parameterNames}, new Class[][]{parameterTypes});
    }

    public void setThrownExceptions(Class[] thrownExceptions) {
        this.setThrownExceptions(new Class[][]{thrownExceptions});
    }

    public final void cook(Scanner scanner) throws CompileException, IOException {
        this.cook(new Scanner[]{scanner});
    }

    public Object evaluate(Object[] arguments) throws InvocationTargetException {
        return this.evaluate(0, arguments);
    }

    public void setReturnTypes(Class[] returnTypes) {
        this.assertNotCooked();
        this.optionalReturnTypes = (Class[])returnTypes.clone();
    }

    public void setParameters(String[][] parameterNames, Class[][] parameterTypes) {
        this.assertNotCooked();
        this.optionalParameterNames = (String[][])parameterNames.clone();
        this.optionalParameterTypes = (Class[][])parameterTypes.clone();
    }

    public void setThrownExceptions(Class[][] thrownExceptions) {
        this.assertNotCooked();
        this.optionalThrownExceptions = (Class[][])thrownExceptions.clone();
    }

    public final void cook(Scanner[] scanners) throws CompileException, IOException {
        int i;
        String[] methodNames;
        if (scanners == null) {
            throw new NullPointerException();
        }
        int count = scanners.length;
        if (this.optionalMethodNames != null && this.optionalMethodNames.length != count) {
            throw new IllegalStateException("methodName");
        }
        if (this.optionalParameterNames != null && this.optionalParameterNames.length != count) {
            throw new IllegalStateException("parameterNames");
        }
        if (this.optionalParameterTypes != null && this.optionalParameterTypes.length != count) {
            throw new IllegalStateException("parameterTypes");
        }
        if (this.optionalReturnTypes != null && this.optionalReturnTypes.length != count) {
            throw new IllegalStateException("returnTypes");
        }
        if (this.optionalStaticMethod != null && this.optionalStaticMethod.length != count) {
            throw new IllegalStateException("staticMethod");
        }
        if (this.optionalThrownExceptions != null && this.optionalThrownExceptions.length != count) {
            throw new IllegalStateException("thrownExceptions");
        }
        this.setUpClassLoaders();
        Java.CompilationUnit compilationUnit = this.makeCompilationUnit(count == 1 ? scanners[0] : null);
        Java.PackageMemberClassDeclaration cd = this.addPackageMemberClassDeclaration(scanners[0].location(), compilationUnit);
        if (this.optionalMethodNames == null) {
            methodNames = new String[count];
            for (i = 0; i < count; ++i) {
                methodNames[i] = "eval" + i;
            }
        } else {
            methodNames = this.optionalMethodNames;
        }
        for (i = 0; i < count; ++i) {
            Scanner scanner = scanners[i];
            List statements = this.makeStatements(i, scanner);
            boolean staticMethod = this.optionalStaticMethod == null || this.optionalStaticMethod[i];
            Class returnType = this.optionalReturnTypes == null ? this.getDefaultReturnType() : this.optionalReturnTypes[i];
            String[] parameterNames = this.optionalParameterNames == null ? new String[]{} : this.optionalParameterNames[i];
            Class[] parameterTypes = this.optionalParameterTypes == null ? new Class[]{} : this.optionalParameterTypes[i];
            Class[] thrownExceptions = this.optionalThrownExceptions == null ? new Class[]{} : this.optionalThrownExceptions[i];
            cd.addDeclaredMethod(this.makeMethodDeclaration(scanner.location(), staticMethod, returnType, methodNames[i], parameterTypes, parameterNames, thrownExceptions, statements));
        }
        Class c = this.compileToClass(compilationUnit, this.className);
        this.result = new Method[count];
        if (count <= 10) {
            for (int i2 = 0; i2 < count; ++i2) {
                try {
                    this.result[i2] = c.getDeclaredMethod(methodNames[i2], this.optionalParameterTypes == null ? new Class[]{} : this.optionalParameterTypes[i2]);
                    continue;
                }
                catch (NoSuchMethodException ex) {
                    throw new JaninoRuntimeException("SNO: Loaded class does not declare method \"" + methodNames[i2] + "\"");
                }
            }
        } else {
            Method m;
            int i3;
            Method[] ma = c.getDeclaredMethods();
            class MethodWrapper {
                private final String name;
                private final Class[] parameterTypes;

                MethodWrapper(String name, Class[] parameterTypes) {
                    this.name = name;
                    this.parameterTypes = parameterTypes;
                }

                public boolean equals(Object o) {
                    if (!(o instanceof MethodWrapper)) {
                        return false;
                    }
                    MethodWrapper that = (MethodWrapper)o;
                    if (!this.name.equals(that.name)) {
                        return false;
                    }
                    int cnt = this.parameterTypes.length;
                    if (cnt != that.parameterTypes.length) {
                        return false;
                    }
                    for (int i = 0; i < cnt; ++i) {
                        if (this.parameterTypes[i].equals(that.parameterTypes[i])) continue;
                        return false;
                    }
                    return true;
                }

                public int hashCode() {
                    int hc = this.name.hashCode();
                    for (int i = 0; i < this.parameterTypes.length; ++i) {
                        hc ^= this.parameterTypes[i].hashCode();
                    }
                    return hc;
                }
            }
            HashMap<MethodWrapper, Method> dms = new HashMap<MethodWrapper, Method>(2 * count);
            for (i3 = 0; i3 < ma.length; ++i3) {
                m = ma[i3];
                dms.put(new MethodWrapper(m.getName(), m.getParameterTypes()), m);
            }
            for (i3 = 0; i3 < count; ++i3) {
                m = (Method)dms.get(new MethodWrapper(methodNames[i3], this.optionalParameterTypes == null ? new Class[]{} : this.optionalParameterTypes[i3]));
                if (m == null) {
                    throw new JaninoRuntimeException("SNO: Loaded class does not declare method \"" + methodNames[i3] + "\"");
                }
                this.result[i3] = m;
            }
        }
    }

    protected Class getDefaultReturnType() {
        return Void.TYPE;
    }

    protected List makeStatements(int idx, Scanner scanner) throws CompileException, IOException {
        ArrayList<Java.BlockStatement> statements = new ArrayList<Java.BlockStatement>();
        Parser parser = new Parser(scanner);
        while (!scanner.peek().isEOF()) {
            statements.add(parser.parseBlockStatement());
        }
        return statements;
    }

    protected Java.MethodDeclarator makeMethodDeclaration(Location location, boolean staticMethod, Class returnType, String methodName, Class[] parameterTypes, String[] parameterNames, Class[] thrownExceptions, List statements) {
        if (parameterNames.length != parameterTypes.length) {
            throw new JaninoRuntimeException("Lengths of \"parameterNames\" (" + parameterNames.length + ") and \"parameterTypes\" (" + parameterTypes.length + ") do not match");
        }
        Java.FunctionDeclarator.FormalParameter[] fps = new Java.FunctionDeclarator.FormalParameter[parameterNames.length];
        for (int i = 0; i < fps.length; ++i) {
            fps[i] = new Java.FunctionDeclarator.FormalParameter(location, true, this.classToType(location, parameterTypes[i]), parameterNames[i]);
        }
        return new Java.MethodDeclarator(location, null, staticMethod ? (short)9 : 1, this.classToType(location, returnType), methodName, fps, this.classesToTypes(location, thrownExceptions), statements);
    }

    public final Object createInstance(Reader reader) {
        throw new UnsupportedOperationException("createInstance");
    }

    public Object evaluate(int idx, Object[] arguments) throws InvocationTargetException {
        if (this.result == null) {
            throw new IllegalStateException("Must only be called after \"cook()\"");
        }
        try {
            return this.result[idx].invoke(null, arguments);
        }
        catch (IllegalAccessException ex) {
            throw new JaninoRuntimeException(ex.toString());
        }
    }
}

