/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrimitiveArrayBuilder<T> {
    Object _freeBuffer;
    Node<T> _bufferHead;
    Node<T> _bufferTail;
    int _bufferedEntryCount;

    protected PrimitiveArrayBuilder() {
    }

    public Object resetAndStart() {
        this._reset();
        return this._freeBuffer == null ? this._constructArray(12) : this._freeBuffer;
    }

    public final Object appendCompletedChunk(Object fullChunk, int fullChunkLength) {
        Node next = new Node(fullChunk, fullChunkLength);
        if (this._bufferHead == null) {
            this._bufferTail = next;
            this._bufferHead = this._bufferTail;
        } else {
            this._bufferTail.linkNext(next);
            this._bufferTail = next;
        }
        this._bufferedEntryCount += fullChunkLength;
        int nextLen = fullChunkLength;
        nextLen = nextLen < 16384 ? (nextLen += nextLen) : (nextLen += nextLen >> 2);
        return this._constructArray(nextLen);
    }

    public Object completeAndClearBuffer(Object lastChunk, int lastChunkEntries) {
        int totalSize = lastChunkEntries + this._bufferedEntryCount;
        Object resultArray = this._constructArray(totalSize);
        int ptr = 0;
        for (Node<T> n = this._bufferHead; n != null; n = n.next()) {
            ptr = n.copyData(resultArray, ptr);
        }
        System.arraycopy(lastChunk, 0, resultArray, ptr, lastChunkEntries);
        if ((ptr += lastChunkEntries) != totalSize) {
            throw new IllegalStateException("Should have gotten " + totalSize + " entries, got " + ptr);
        }
        return resultArray;
    }

    protected abstract Object _constructArray(int var1);

    protected void _reset() {
        if (this._bufferTail != null) {
            this._freeBuffer = this._bufferTail.getData();
        }
        this._bufferTail = null;
        this._bufferHead = null;
        this._bufferedEntryCount = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Node<T> {
        final Object _data;
        final int _dataLength;
        Node<T> _next;

        public Node(Object data, int dataLen) {
            this._data = data;
            this._dataLength = dataLen;
        }

        public Object getData() {
            return this._data;
        }

        public int copyData(Object dst, int ptr) {
            System.arraycopy(this._data, 0, dst, ptr, this._dataLength);
            return ptr += this._dataLength;
        }

        public Node<T> next() {
            return this._next;
        }

        public void linkNext(Node<T> next) {
            if (this._next != null) {
                throw new IllegalStateException();
            }
            this._next = next;
        }
    }
}

